/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.notenoughchests.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.IOUtils;

public class DownloadAndZipUtils {
    public static void downloadUsingStream(URL url, File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        BufferedInputStream bis = new BufferedInputStream(url.openStream());
        FileOutputStream fis = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        int count = 0;
        while ((count = bis.read(buffer, 0, 1024)) != -1) {
            fis.write(buffer, 0, count);
        }
        fis.close();
        bis.close();
    }

    public static void unzip(File zipFile, File destDir) throws IOException {
        String destDirectory = destDir.getAbsolutePath();
        try (ZipArchiveInputStream i = new ZipArchiveInputStream((InputStream)new FileInputStream(zipFile), "UTF-8", false, true);){
            ArchiveEntry entry = null;
            while ((entry = i.getNextEntry()) != null) {
                if (!i.canReadEntryData(entry)) {
                    System.out.println("Can't read entry: " + entry);
                    continue;
                }
                String name = destDirectory + File.separator + entry.getName();
                File f = new File(name);
                if (entry.isDirectory()) {
                    if (f.isDirectory() || f.mkdirs()) continue;
                    throw new IOException("failed to create directory " + f);
                }
                File parent = f.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("failed to create directory " + parent);
                }
                OutputStream o = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                try {
                    IOUtils.copy((InputStream)i, (OutputStream)o);
                }
                finally {
                    if (o == null) continue;
                    o.close();
                }
            }
        }
    }
}

