/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.notenoughchests.custompack.generation;

import fr.iglee42.notenoughchests.NotEnoughChests;
import fr.iglee42.notenoughchests.custompack.PathConstant;
import fr.iglee42.notenoughchests.custompack.generation.TextureKey;
import fr.iglee42.notenoughchests.utils.ModAbbreviation;
import java.io.File;
import java.io.FileWriter;

public class ModelsGenerator {
    public static void generate() {
        NotEnoughChests.WOOD_TYPES.forEach(wt -> {
            String t = wt.m_135815_();
            ModelsGenerator.itemFromParent(ModAbbreviation.getModAbbrevation(wt.m_135827_()) + t + "_chest", "nec:item/chest_base", new TextureKey("wood_type", "nec:entity/chest/single/" + ModAbbreviation.getChestTexture(wt)));
            ModelsGenerator.blockFromParent(ModAbbreviation.getModAbbrevation(wt.m_135827_()) + t + "_chest", "minecraft:block/chest", new TextureKey("particle", "nec:entity/chest/single/" + ModAbbreviation.getChestTexture(wt)));
            ModelsGenerator.itemFromParent(ModAbbreviation.getModAbbrevation(wt.m_135827_()) + t + "_trapped_chest", "nec:item/chest_base", new TextureKey("wood_type", "nec:entity/chest/trapped_single/" + ModAbbreviation.getChestTexture(wt)));
            ModelsGenerator.blockFromParent(ModAbbreviation.getModAbbrevation(wt.m_135827_()) + t + "_trapped_chest", "minecraft:block/chest", new TextureKey("particle", "nec:entity/chest/trapped_single/" + ModAbbreviation.getChestTexture(wt)));
        });
    }

    private static void itemFromBlock(String name) {
        ModelsGenerator.itemFromParent(name, "nec:block/" + name, new TextureKey[0]);
    }

    private static void itemFromParent(String name, String parent, TextureKey ... textureKeys) {
        String jsonBase = "{\n   \"parent\": \"" + parent + "\"" + (textureKeys.length > 0 ? "," : "") + "\n";
        StringBuilder builder = new StringBuilder(jsonBase);
        if (textureKeys.length > 0) {
            builder.append("   \"textures\": {\n");
            for (int i = 0; i < textureKeys.length; ++i) {
                builder.append(textureKeys[i].toJson());
                if (i != textureKeys.length - 1) {
                    builder.append(",");
                }
                builder.append("\n");
            }
            builder.append("    }\n");
        }
        builder.append("}");
        ModelsGenerator.generateItem(name, builder.toString());
    }

    private static void generateItem(String name, String fileText) {
        try {
            FileWriter writer = new FileWriter(new File(PathConstant.ITEM_MODELS_PATH.toFile(), name + ".json"));
            writer.write(fileText);
            writer.close();
        }
        catch (Exception exception) {
            NotEnoughChests.LOGGER.error("An error was detected when models generating", (Throwable)exception);
        }
    }

    private static void blockFromParent(String name, String parent, TextureKey ... textureKeys) {
        String jsonBase = "{\n   \"parent\": \"" + parent + "\",\n";
        StringBuilder builder = new StringBuilder(jsonBase);
        if (textureKeys.length > 0) {
            builder.append("   \"textures\": {\n");
            for (int i = 0; i < textureKeys.length; ++i) {
                builder.append(textureKeys[i].toJson());
                if (i != textureKeys.length - 1) {
                    builder.append(",");
                }
                builder.append("\n");
            }
            builder.append("    }\n");
        }
        builder.append("}");
        ModelsGenerator.generateBlock(name, builder.toString());
    }

    private static void generateBlock(String name, String fileText) {
        try {
            FileWriter writer = new FileWriter(new File(PathConstant.BLOCK_MODELS_PATH.toFile(), name + ".json"));
            writer.write(fileText);
            writer.close();
        }
        catch (Exception exception) {
            NotEnoughChests.LOGGER.error("An error was detected when models generating", (Throwable)exception);
        }
    }
}

