/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.notenoughchests.custompack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import fr.iglee42.notenoughchests.NotEnoughChests;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InMemoryPack
implements PackResources {
    private final Path path;

    public InMemoryPack(Path path) {
        this.path = path;
        NotEnoughChests.generateData();
    }

    private static String getFullPath(PackType type, ResourceLocation location) {
        return String.format("%s/%s/%s", type.m_10305_(), location.m_135827_(), location.m_135815_());
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... p_252049_) {
        Path resolved = this.path.resolve(p_252049_[0]);
        return IoSupplier.m_246697_((Path)resolved);
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        Path resolved = this.path.resolve(InMemoryPack.getFullPath(type, location));
        if (!Files.exists(resolved, new LinkOption[0])) {
            return null;
        }
        return IoSupplier.m_246697_((Path)resolved);
    }

    public void m_8031_(PackType p_10289_, String p_251379_, String p_251932_, PackResources.ResourceOutput p_249347_) {
        ArrayList<Pair<ResourceLocation, String>> result = new ArrayList<Pair<ResourceLocation, String>>();
        this.getChildResourceLocations(result, 100, x -> true, this.path.resolve(p_10289_.m_10305_()).resolve(p_251379_).resolve(p_251932_), p_251379_, p_251932_);
        for (Pair<ResourceLocation, String> row : result) {
            p_249347_.accept((Object)((ResourceLocation)row.getFirst()), (Object)IoSupplier.m_246697_((Path)Path.of((String)row.getSecond(), new String[0])));
        }
    }

    private void getChildResourceLocations(List<Pair<ResourceLocation, String>> result, int depth, Predicate<ResourceLocation> filter, Path current, String currentRLNS, String currentRLPath) {
        try {
            if (!Files.exists(current, new LinkOption[0]) || !Files.isDirectory(current, new LinkOption[0])) {
                return;
            }
            Stream<Path> list = Files.list(current);
            for (Path child : list.toList()) {
                if (!Files.isDirectory(child, new LinkOption[0])) {
                    result.add((Pair<ResourceLocation, String>)new Pair((Object)new ResourceLocation(currentRLNS, currentRLPath + "/" + child.getFileName()), (Object)child.toString()));
                    continue;
                }
                this.getChildResourceLocations(result, depth + 1, filter, child, currentRLNS, currentRLPath + "/" + child.getFileName());
            }
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
    }

    @NotNull
    public Set<String> m_5698_(PackType type) {
        HashSet<String> result = new HashSet<String>();
        try {
            Stream<Path> list = Files.list(this.path.resolve(type.m_10305_()));
            for (Path resultingPath : list.collect(Collectors.toList())) {
                result.add(resultingPath.getFileName().toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        JsonObject jsonobject = new JsonObject();
        JsonObject packObject = new JsonObject();
        packObject.addProperty("pack_format", (Number)16);
        packObject.addProperty("description", "nec");
        jsonobject.add("pack", (JsonElement)packObject);
        if (!jsonobject.has(deserializer.m_7991_())) {
            return null;
        }
        try {
            return (T)deserializer.m_6322_(jsonobject.get(deserializer.m_7991_()).getAsJsonObject());
        }
        catch (JsonParseException jsonparseexception) {
            return null;
        }
    }

    public String m_5542_() {
        return "NEC InCode Pack";
    }

    public void close() {
    }
}

