/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.notenoughchests.chest;

import fr.iglee42.notenoughchests.NotEnoughChests;
import fr.iglee42.notenoughchests.chest.CustomChestBlockEntity;
import fr.iglee42.notenoughchests.chest.CustomTrappedChestBlockEntity;
import fr.iglee42.notenoughchests.utils.ModAbbreviation;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomChestRenderer
extends ChestRenderer<CustomChestBlockEntity> {
    public static Map<ResourceLocation, Material> single = new HashMap<ResourceLocation, Material>();
    public static Map<ResourceLocation, Material> left = new HashMap<ResourceLocation, Material>();
    public static Map<ResourceLocation, Material> right = new HashMap<ResourceLocation, Material>();
    public static Map<ResourceLocation, Material> single_trapped = new HashMap<ResourceLocation, Material>();
    public static Map<ResourceLocation, Material> left_trapped = new HashMap<ResourceLocation, Material>();
    public static Map<ResourceLocation, Material> right_trapped = new HashMap<ResourceLocation, Material>();
    private static boolean christmas;

    public CustomChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            christmas = true;
        }
    }

    protected Material getMaterial(CustomChestBlockEntity blockEntity, ChestType chestType) {
        return this.getChestMaterial(blockEntity, chestType);
    }

    public static Material chooseMaterial(ChestType type, Material left, Material right, Material single) {
        return switch (type) {
            case ChestType.LEFT -> left;
            case ChestType.RIGHT -> right;
            default -> single;
        };
    }

    private static Material getChestMaterial(String path, String type) {
        return new Material(Sheets.f_110740_, new ResourceLocation("nec", "entity/chest/" + type + "/" + path));
    }

    private static Material getTrappedMaterial(String path, String type) {
        return new Material(Sheets.f_110740_, new ResourceLocation("nec", "entity/chest/trapped_" + type + "/" + path));
    }

    private Material getChestMaterial(CustomChestBlockEntity tile, ChestType type) {
        if (christmas) {
            return Sheets.m_110767_((BlockEntity)tile, (ChestType)type, (boolean)true);
        }
        if (tile instanceof CustomTrappedChestBlockEntity) {
            return CustomChestRenderer.chooseMaterial(type, left_trapped.get(NotEnoughChests.WOOD_TYPES.get(tile.getChestTypeIndex())), right_trapped.get(NotEnoughChests.WOOD_TYPES.get(tile.getChestTypeIndex())), single_trapped.get(NotEnoughChests.WOOD_TYPES.get(tile.getChestTypeIndex())));
        }
        return CustomChestRenderer.chooseMaterial(type, left.get(NotEnoughChests.WOOD_TYPES.get(tile.getChestTypeIndex())), right.get(NotEnoughChests.WOOD_TYPES.get(tile.getChestTypeIndex())), single.get(NotEnoughChests.WOOD_TYPES.get(tile.getChestTypeIndex())));
    }

    static {
        for (int i = 0; i < NotEnoughChests.WOOD_TYPES.size(); ++i) {
            ResourceLocation type = NotEnoughChests.WOOD_TYPES.get(i);
            single.put(type, CustomChestRenderer.getChestMaterial(ModAbbreviation.getChestTexture(type), "single"));
            left.put(type, CustomChestRenderer.getChestMaterial(ModAbbreviation.getChestTexture(type), "left"));
            right.put(type, CustomChestRenderer.getChestMaterial(ModAbbreviation.getChestTexture(type), "right"));
            single_trapped.put(type, CustomChestRenderer.getTrappedMaterial(ModAbbreviation.getChestTexture(type), "single"));
            left_trapped.put(type, CustomChestRenderer.getTrappedMaterial(ModAbbreviation.getChestTexture(type), "left"));
            right_trapped.put(type, CustomChestRenderer.getTrappedMaterial(ModAbbreviation.getChestTexture(type), "right"));
        }
    }
}

