/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.notenoughchests;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import fr.iglee42.notenoughchests.NECCommonConfig;
import fr.iglee42.notenoughchests.chest.CustomChestBlock;
import fr.iglee42.notenoughchests.chest.CustomChestBlockEntity;
import fr.iglee42.notenoughchests.chest.CustomTrappedChestBlock;
import fr.iglee42.notenoughchests.chest.CustomTrappedChestBlockEntity;
import fr.iglee42.notenoughchests.custompack.NECPackFinder;
import fr.iglee42.notenoughchests.custompack.PackType;
import fr.iglee42.notenoughchests.custompack.PathConstant;
import fr.iglee42.notenoughchests.custompack.generation.BlockStatesGenerator;
import fr.iglee42.notenoughchests.custompack.generation.LangsGenerator;
import fr.iglee42.notenoughchests.custompack.generation.LootTablesGenerator;
import fr.iglee42.notenoughchests.custompack.generation.ModelsGenerator;
import fr.iglee42.notenoughchests.custompack.generation.RecipesGenerator;
import fr.iglee42.notenoughchests.custompack.generation.TagsGenerator;
import fr.iglee42.notenoughchests.utils.DownloadAndZipUtils;
import fr.iglee42.notenoughchests.utils.ModAbbreviation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="nec")
public class NotEnoughChests {
    public static final String MODID = "nec";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"nec");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"nec");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"nec");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"nec");
    public static final RegistryObject<CreativeModeTab> TAB = CREATIVE_MODE_TABS.register("tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.nec")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257737_(() -> ((Item)Items.f_42009_).m_7968_()).m_257652_());
    public static final RegistryObject<BlockEntityType<CustomChestBlockEntity>> CHEST = BLOCK_ENTITIES.register("chest", () -> BlockEntityType.Builder.m_155273_(CustomChestBlockEntity::new, (Block[])new Block[0]).m_58966_(null));
    public static final RegistryObject<BlockEntityType<CustomTrappedChestBlockEntity>> TRAPPED_CHEST = BLOCK_ENTITIES.register("trapped_chest", () -> BlockEntityType.Builder.m_155273_(CustomTrappedChestBlockEntity::new, (Block[])new Block[0]).m_58966_(null));
    public static List<ResourceLocation> WOOD_TYPES;
    public static List<String> PLANK_TYPES;
    public static Map<ResourceLocation, String> PLANK_NAME_FORMAT;
    private static boolean hasGenerated;
    public static boolean textureServerOnline;
    private static JsonObject chestTextureIds;

    public NotEnoughChests() {
        hasGenerated = false;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        try {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                URL url = new URL("https://iglee.fr:3000/chests");
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                con.setConnectTimeout(5000);
                con.setReadTimeout(1000);
                con.setInstanceFollowRedirects(false);
                int status = con.getResponseCode();
                if (status == 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    StringBuilder json = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        try {
                            json.append(inputLine);
                        }
                        catch (Exception exception) {}
                    }
                    chestTextureIds = (JsonObject)new Gson().fromJson(json.toString(), JsonObject.class);
                    in.close();
                } else {
                    textureServerOnline = false;
                }
                con.disconnect();
            }
        }
        catch (Exception ignored) {
            textureServerOnline = false;
        }
        WOOD_TYPES = new ArrayList<ResourceLocation>();
        PLANK_TYPES = new ArrayList<String>();
        PLANK_NAME_FORMAT = new HashMap<ResourceLocation, String>();
        ForgeRegistries.BLOCKS.getKeys().stream().filter(rs -> rs.m_135815_().endsWith("_planks")).forEach(rs -> {
            String woodType = rs.m_135815_().replace("_planks", "");
            PLANK_TYPES.add(woodType);
            WOOD_TYPES.add(new ResourceLocation(rs.m_135815_().replace("_planks", "").toLowerCase()));
            PLANK_NAME_FORMAT.put(new ResourceLocation(rs.m_135815_().replace("_planks", "").toLowerCase()), "_planks");
            int index = WOOD_TYPES.indexOf(new ResourceLocation(rs.m_135815_().replace("_planks", "").toLowerCase()));
            RegistryObject chest = BLOCKS.register(woodType.toLowerCase() + "_chest", () -> new CustomChestBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_278183_(), () -> CHEST.get(), index));
            RegistryObject trappedChest = BLOCKS.register(woodType.toLowerCase() + "_trapped_chest", () -> new CustomTrappedChestBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_278183_(), index));
            ITEMS.register(woodType.toLowerCase() + "_chest", () -> new BlockItem((Block)chest.get(), new Item.Properties()){

                public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                    return 300;
                }
            });
            ITEMS.register(woodType.toLowerCase() + "_trapped_chest", () -> new BlockItem((Block)trappedChest.get(), new Item.Properties()){

                public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                    return 300;
                }
            });
        });
        if (ModList.get().isLoaded("integrateddynamics")) {
            String woodType = "menril";
            PLANK_TYPES.add(woodType);
            WOOD_TYPES.add(new ResourceLocation("integrateddynamics", woodType));
            PLANK_NAME_FORMAT.put(new ResourceLocation("integrateddynamics", woodType), "_planks");
            RegistryObject chest = BLOCKS.register(woodType.toLowerCase() + "_chest", () -> new CustomChestBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_278183_(), () -> CHEST.get(), PLANK_TYPES.indexOf(woodType)));
            RegistryObject trappedChest = BLOCKS.register(woodType.toLowerCase() + "_trapped_chest", () -> new CustomTrappedChestBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_278183_(), PLANK_TYPES.indexOf(woodType)));
            ITEMS.register(woodType.toLowerCase() + "_chest", () -> new BlockItem((Block)chest.get(), new Item.Properties()){

                public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                    return 300;
                }
            });
            ITEMS.register(woodType.toLowerCase() + "_trapped_chest", () -> new BlockItem((Block)trappedChest.get(), new Item.Properties()){

                public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                    return 300;
                }
            });
        }
        try {
            NECCommonConfig.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BLOCKS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        PathConstant.init();
        MinecraftForge.EVENT_BUS.addListener(this::onServerStart);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        modEventBus.addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                Minecraft.m_91087_().m_91099_().addPackFinder((RepositorySource)new NECPackFinder(PackType.RESOURCE));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    public static void onRegistryObjectCreated(ResourceLocation registryName, ResourceLocation id, RegisterEvent event) {
        if (NECCommonConfig.modsBlacklist.contains(id.m_135827_())) {
            return;
        }
        if (id.m_135827_().equals("ad_astra")) {
            return;
        }
        if (registryName.m_135815_().equals("block")) {
            if (id.m_135815_().endsWith("_planks") || id.m_135815_().startsWith("plank_")) {
                String woodType = id.m_135815_().replace("_planks", "").replace("plank_", "");
                WOOD_TYPES.add(new ResourceLocation(id.m_135827_(), woodType.toLowerCase()));
                PLANK_TYPES.add(woodType);
                PLANK_NAME_FORMAT.put(new ResourceLocation(id.m_135827_(), woodType.toLowerCase()), id.m_135815_().endsWith("_planks") ? "_planks" : (id.m_135815_().startsWith("plank_") ? "plank_" : ""));
                event.register(ForgeRegistries.Keys.BLOCKS, new ResourceLocation(MODID, ModAbbreviation.getModAbbrevation(id.m_135827_()) + woodType + "_chest"), () -> new CustomChestBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_278183_(), () -> CHEST.get(), WOOD_TYPES.indexOf(new ResourceLocation(id.m_135827_(), woodType.toLowerCase()))));
                event.register(ForgeRegistries.Keys.BLOCKS, new ResourceLocation(MODID, ModAbbreviation.getModAbbrevation(id.m_135827_()) + woodType + "_trapped_chest"), () -> new CustomTrappedChestBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_278183_(), WOOD_TYPES.indexOf(new ResourceLocation(id.m_135827_(), woodType.toLowerCase()))));
            }
        } else if (registryName.m_135815_().equals("item") && (id.m_135815_().endsWith("_planks") || id.m_135815_().startsWith("plank_"))) {
            String woodType = id.m_135815_().replace("_planks", "").replace("plank_", "");
            event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation(MODID, ModAbbreviation.getModAbbrevation(id.m_135827_()) + woodType + "_chest"), () -> new BlockItem((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(MODID, ModAbbreviation.getModAbbrevation(id.m_135827_()) + woodType + "_chest")), new Item.Properties()){

                public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                    return 300;
                }
            });
            event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation(MODID, ModAbbreviation.getModAbbrevation(id.m_135827_()) + woodType + "_trapped_chest"), () -> new BlockItem((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(MODID, ModAbbreviation.getModAbbrevation(id.m_135827_()) + woodType + "_trapped_chest")), new Item.Properties()){

                public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                    return 300;
                }
            });
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == TAB.getKey()) {
            ForgeRegistries.ITEMS.getKeys().stream().filter(rs -> rs.m_135827_().equals(MODID)).forEach(rs -> event.m_246326_((ItemLike)ForgeRegistries.ITEMS.getValue(rs)));
        }
    }

    public void onServerStarted(ServerStartedEvent event) {
    }

    public void onServerStart(ServerAboutToStartEvent event) {
        event.getServer().m_129891_().addPackFinder((RepositorySource)new NECPackFinder(PackType.DATA));
    }

    public static void generateData() {
        if (!hasGenerated) {
            if (!ModLoader.isLoadingStateValid()) {
                return;
            }
            if (FMLEnvironment.dist == Dist.CLIENT) {
                if (textureServerOnline) {
                    ArrayList idsToDownload = new ArrayList();
                    WOOD_TYPES.forEach(wt -> {
                        String abrev = ModAbbreviation.getModAbbrevation(wt.m_135827_());
                        HashMap ids = new HashMap();
                        if (chestTextureIds != null) {
                            chestTextureIds.asMap().forEach((id, el) -> ids.put(id, el.getAsInt()));
                        }
                        int id2 = abrev.isEmpty() ? ids.getOrDefault(wt.m_135815_(), -1).intValue() : ids.getOrDefault(abrev.replace("_", "") + "/" + wt.m_135815_(), -1).intValue();
                        idsToDownload.add(id2);
                    });
                    StringBuilder array = new StringBuilder("[");
                    for (int i = 0; i < idsToDownload.size(); ++i) {
                        array.append(idsToDownload.get(i));
                        if (i >= idsToDownload.size() - 1) continue;
                        array.append(",");
                    }
                    array.append("]");
                    try {
                        URL url = new URL("https://iglee.fr:3000/chestTextures?chests=" + array);
                        File zipFile = new File(PathConstant.ROOT_PATH.toString(), "chests.zip");
                        DownloadAndZipUtils.downloadUsingStream(url, zipFile);
                        DownloadAndZipUtils.unzip(zipFile, PathConstant.CHEST_TEXTURES_PATH.toFile());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ModelsGenerator.generate();
                BlockStatesGenerator.generate();
                LangsGenerator.generate();
            }
            RecipesGenerator.generate();
            TagsGenerator.generate();
            LootTablesGenerator.generate();
            hasGenerated = true;
        }
    }

    public static void injectDatapackFinder(PackRepository resourcePacks) {
        if (((Boolean)DistExecutor.unsafeRunForDist(() -> () -> resourcePacks != Minecraft.m_91087_().m_91099_(), () -> () -> true)).booleanValue()) {
            resourcePacks.addPackFinder((RepositorySource)new NECPackFinder(PackType.DATA));
        }
    }

    static {
        textureServerOnline = true;
    }
}

