/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.server;

import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.inventory.DankInterface;
import tfar.dankstorage.network.PacketIds;
import tfar.dankstorage.network.client.S2CContentsForDisplayPacket;
import tfar.dankstorage.network.server.C2SModPacket;
import tfar.dankstorage.platform.Services;

public class C2SRequestContentsPacket
implements C2SModPacket {
    private final int frequency;

    public C2SRequestContentsPacket(int frequency) {
        this.frequency = frequency;
    }

    public C2SRequestContentsPacket(FriendlyByteBuf buf) {
        this.frequency = buf.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.frequency);
    }

    public static void send(int frequency) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(frequency);
        Services.PLATFORM.sendToServer(new C2SRequestContentsPacket(frequency), PacketIds.request_contents);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        DankInterface dankInventoryForge = DankStorage.getData(this.frequency, player.f_8924_).createInventory(this.frequency);
        Services.PLATFORM.sendToClient(new S2CContentsForDisplayPacket(dankInventoryForge.getContents()), PacketIds.sync_dank_inventory, player);
    }
}

