/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.ItemStackWrapper;

public interface DankInterface
extends ContainerData {
    public static final String GHOST = "GhostItems";
    public static final int FREQ = 0;
    public static final int TXT_COLOR = 1;
    public static final int FREQ_LOCK = 2;

    default public ItemStack getGhostItem(int slot) {
        return (ItemStack)this.getGhostItems().get(slot);
    }

    public DankStats getDankStats();

    default public boolean frequencyLocked() {
        return this.m_6413_(2) == 1;
    }

    default public int textColor() {
        return this.m_6413_(1);
    }

    default public void setTextColor(int color) {
        this.m_8050_(1, color);
    }

    default public void toggleFrequencyLock() {
        boolean loc = this.frequencyLocked();
        this.setFrequencyLock(!loc);
    }

    default public void setFrequencyLock(boolean lock) {
        this.m_8050_(2, lock ? 1 : 0);
    }

    public void setItemDank(int var1, ItemStack var2);

    public ItemStack getItemDank(int var1);

    default public void setGhostItem(int slot, Item item) {
        this.getGhostItems().set(slot, (Object)new ItemStack((ItemLike)item));
    }

    public NonNullList<ItemStack> getContents();

    public void setItemsDank(NonNullList<ItemStack> var1);

    public NonNullList<ItemStack> getGhostItems();

    public void setGhostItems(NonNullList<ItemStack> var1);

    default public int frequency() {
        return this.m_6413_(0);
    }

    default public int m_6499_() {
        return 3;
    }

    public int getContainerSizeDank();

    public ItemStack addItemDank(int var1, ItemStack var2);

    default public void readGhostItems(ListTag listTag) {
        for (int i = 0; i < listTag.size(); ++i) {
            ItemStack stack;
            CompoundTag itemTags = listTag.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.getContainerSizeDank()) continue;
            if (itemTags.m_128425_("StackList", 9)) {
                stack = ItemStack.f_41583_;
                ListTag stackTagList = itemTags.m_128437_("StackList", 10);
                for (int j = 0; j < stackTagList.size(); ++j) {
                    CompoundTag itemTag = stackTagList.m_128728_(j);
                    ItemStack temp = ItemStack.m_41712_((CompoundTag)itemTag);
                    if (temp.m_41619_()) continue;
                    if (stack.m_41619_()) {
                        stack = temp;
                        continue;
                    }
                    stack.m_41769_(temp.m_41613_());
                }
                if (stack.m_41619_()) continue;
                this.getGhostItems().set(slot, (Object)stack);
                continue;
            }
            stack = ItemStack.m_41712_((CompoundTag)itemTags);
            this.getGhostItems().set(slot, (Object)stack);
        }
    }

    default public int getMaxStackSizeSensitive(ItemStack stack) {
        return stack.m_204117_(ModTags.UNSTACKABLE) ? 1 : this.getMaxStackSizeDank();
    }

    default public void sort() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.getContents()) {
            if (stack.m_41619_()) continue;
            CommonUtils.merge(stacks, stack.m_41777_());
        }
        List<ItemStackWrapper> wrappers = CommonUtils.wrap(stacks);
        Collections.sort(wrappers);
        for (int i = 0; i < this.getContainerSizeDank(); ++i) {
            this.setItemDank(i, ItemStack.f_41583_);
            this.getGhostItems().set(i, (Object)ItemStack.f_41583_);
        }
        int slotId = 0;
        for (int i = 0; i < wrappers.size(); ++i) {
            int stackSizeSensitive;
            ItemStack stack = wrappers.get((int)i).stack;
            int count = stack.m_41613_();
            if (count > (stackSizeSensitive = this.getMaxStackSizeSensitive(stack))) {
                int fullStacks = count / stackSizeSensitive;
                int partialStack = count - fullStacks * stackSizeSensitive;
                for (int j = 0; j < fullStacks; ++j) {
                    this.setItemDank(slotId, CommonUtils.copyStackWithSize(stack, stackSizeSensitive));
                    ++slotId;
                }
                if (partialStack <= 0) continue;
                this.setItemDank(slotId, CommonUtils.copyStackWithSize(stack, partialStack));
                ++slotId;
                continue;
            }
            this.setItemDank(slotId, stack);
            ++slotId;
        }
    }

    default public void compress(ServerPlayer player) {
        ItemStack stack;
        this.sort();
        ServerLevel level = player.m_284548_();
        ArrayList<ItemStack> addLater = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getMaxStackSizeDank() && !(stack = this.getItemDank(i)).m_41619_(); ++i) {
            Pair<ItemStack, Integer> result;
            ItemStack resultStack;
            if (!CommonUtils.canCompress(level, stack) || (resultStack = (ItemStack)(result = CommonUtils.compress(stack, player.m_284548_().m_9598_())).getFirst()).m_41619_()) continue;
            int division = (Integer)result.getSecond();
            int compressedCount = stack.m_41613_() / division;
            int remainderCount = stack.m_41613_() % division;
            this.setItemDank(i, CommonUtils.copyStackWithSize(resultStack, compressedCount));
            addLater.add(CommonUtils.copyStackWithSize(stack, remainderCount));
        }
        this.sort();
        for (ItemStack itemStack : addLater) {
            ItemStack remainder = itemStack.m_41777_();
            for (int i = 0; i < this.getContainerSizeDank() && !(remainder = this.addItemDank(i, remainder)).m_41619_(); ++i) {
            }
            if (remainder.m_41619_()) continue;
            player.m_36356_(remainder);
            if (remainder.m_41619_()) continue;
            player.m_36176_(remainder, false);
        }
        this.sort();
    }

    default public void readItems(ListTag listTag) {
        for (int i = 0; i < listTag.size(); ++i) {
            ItemStack stack;
            CompoundTag itemTags = listTag.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.getContainerSizeDank()) continue;
            if (itemTags.m_128425_("StackList", 9)) {
                stack = ItemStack.f_41583_;
                ListTag stackTagList = itemTags.m_128437_("StackList", 10);
                for (int j = 0; j < stackTagList.size(); ++j) {
                    CompoundTag itemTag = stackTagList.m_128728_(j);
                    ItemStack temp = ItemStack.m_41712_((CompoundTag)itemTag);
                    if (temp.m_41619_()) continue;
                    if (stack.m_41619_()) {
                        stack = temp;
                        continue;
                    }
                    stack.m_41769_(temp.m_41613_());
                }
                if (stack.m_41619_()) continue;
                int count = stack.m_41613_();
                count = Math.min(count, this.getMaxStackSizeDank());
                stack.m_41764_(count);
                this.setItemDank(slot, stack);
                continue;
            }
            stack = ItemStack.m_41712_((CompoundTag)itemTags);
            if (itemTags.m_128425_("ExtendedCount", 3)) {
                stack.m_41764_(itemTags.m_128451_("ExtendedCount"));
            }
            this.setItemDank(slot, stack);
        }
    }

    public MinecraftServer getServer();

    public void setServer(MinecraftServer var1);

    public void setDankStats(DankStats var1);

    default public CompoundTag save() {
        CompoundTag itemTag;
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.getContents().size(); ++i) {
            if (((ItemStack)this.getContents().get(i)).m_41619_()) continue;
            int realCount = Math.min(this.getDankStats().stacklimit, ((ItemStack)this.getContents().get(i)).m_41613_());
            itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.getContents().get(i)).m_41739_(itemTag);
            itemTag.m_128405_("ExtendedCount", realCount);
            nbtTagList.add((Object)itemTag);
        }
        ListTag ghostItemNBT = new ListTag();
        for (int i = 0; i < this.getContents().size(); ++i) {
            if (((ItemStack)this.getGhostItems().get(i)).m_41619_()) continue;
            itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.getGhostItems().get(i)).m_41739_(itemTag);
            ghostItemNBT.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128365_(GHOST, (Tag)ghostItemNBT);
        nbt.m_128359_("DankStats", this.getDankStats().name());
        nbt.m_128379_("locked", this.frequencyLocked());
        return nbt;
    }

    default public void read(CompoundTag nbt) {
        DankStats stats = DankStats.valueOf(nbt.m_128461_("DankStats"));
        this.setDankStats(stats);
        ListTag tagList = nbt.m_128437_("Items", 10);
        this.readItems(tagList);
        ListTag ghostItemList = nbt.m_128437_(GHOST, 10);
        this.readGhostItems(ghostItemList);
        this.setFrequencyLock(nbt.m_128471_("locked"));
        this.validate();
    }

    default public int calcRedstone() {
        int numStacks = 0;
        float f = 0.0f;
        for (int slot = 0; slot < this.getContainerSizeDank(); ++slot) {
            ItemStack stack = this.getItemDank(slot);
            if (stack.m_41619_()) continue;
            f += (float)stack.m_41613_() / (float)this.getMaxStackSizeDank();
            ++numStacks;
        }
        return Mth.m_14143_((float)((f /= (float)this.getContainerSizeDank()) * 14.0f)) + (numStacks > 0 ? 1 : 0);
    }

    default public boolean noValidSlots() {
        return IntStream.range(0, this.getContainerSizeDank()).mapToObj(this::getItemDank).allMatch(stack -> stack.m_41619_() || stack.m_204117_(ModTags.BLACKLISTED_USAGE));
    }

    default public void upgradeTo(DankStats stats) {
        if (stats.ordinal() <= this.getDankStats().ordinal()) {
            return;
        }
        this.setTo(stats);
    }

    default public void setTo(DankStats stats) {
        if (stats != this.getDankStats()) {
            DankStorage.LOG.debug("Upgrading dank #{} from tier {} to {}", new Object[]{this.frequency(), this.getDankStats().name(), stats.name()});
            NonNullList newStacks = NonNullList.m_122780_((int)stats.slots, (Object)ItemStack.f_41583_);
            NonNullList newGhostStacks = NonNullList.m_122780_((int)stats.slots, (Object)ItemStack.f_41583_);
            int oldSlots = this.getContainerSizeDank();
            int max = Math.min(oldSlots, stats.slots);
            for (int i = 0; i < max; ++i) {
                ItemStack oldStack = this.getItemDank(i);
                ItemStack oldGhost = this.getGhostItem(i);
                newStacks.set(i, (Object)oldStack);
                newGhostStacks.set(i, (Object)oldGhost);
            }
            this.setDankStats(stats);
            this.setItemsDank((NonNullList<ItemStack>)newStacks);
            this.setGhostItems((NonNullList<ItemStack>)newGhostStacks);
            this.setChangedDank();
        }
    }

    default public boolean hasGhostItem(int slot) {
        return !((ItemStack)this.getGhostItems().get(slot)).m_41619_();
    }

    public int getMaxStackSizeDank();

    default public void validate() {
        int containerSizeDank = this.getContainerSizeDank();
        if (this.getDankStats() == DankStats.zero) {
            DankStorage.LOG.error("dank has no stats?");
        } else if (containerSizeDank == 0) {
            DankStorage.LOG.error("dank is empty?");
        } else if (this.getGhostItems().size() != containerSizeDank) {
            DankStorage.LOG.error("inequal size");
        }
    }

    default public void copyItems() {
    }

    default public void toggleGhostItem(int slot) {
        boolean loc;
        boolean bl = loc = !((ItemStack)this.getGhostItems().get(slot)).m_41619_();
        if (!loc) {
            this.getGhostItems().set(slot, (Object)CommonUtils.copyStackWithSize(this.getItemDank(slot), 1));
        } else {
            this.getGhostItems().set(slot, (Object)ItemStack.f_41583_);
        }
        this.setChangedDank();
    }

    public void setChangedDank();

    public void setSizeDank(int var1);

    default public void saveToDisk() {
        if (this.getServer() != null) {
            DankStorage.getData(this.frequency(), this.getServer()).write(this.save());
        }
    }

    default public boolean valid() {
        return this.getDankStats() != DankStats.zero;
    }
}

