/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage;

import java.io.File;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tfar.dankstorage.mixin.MinecraftServerAccess;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.world.CDankSavedData;
import tfar.dankstorage.world.MaxId;

public class DankStorage {
    public static final String MODID = "dankstorage";
    public static final String MOD_NAME = "Dank-Storage";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Dank-Storage");
    public static MaxId maxId;

    public static void init() {
    }

    public static MaxId getMaxId(MinecraftServer server) {
        return (MaxId)server.m_129880_(Level.f_46428_).m_8895_().m_164861_(MaxId::loadStatic, MaxId::new, "dankstorage:max_id");
    }

    public static void onServerShutDown(MinecraftServer server) {
        maxId = null;
        CommonUtils.uncacheRecipes();
    }

    public static void onServerStart(MinecraftServer server) {
        LevelStorageSource.LevelStorageAccess storageSource = ((MinecraftServerAccess)server).getStorageSource();
        File file = storageSource.m_197394_(server.m_129880_(Level.f_46428_).m_46472_()).resolve("data/dankstorage").toFile();
        file.mkdirs();
        maxId = DankStorage.getMaxId(server);
    }

    public static CDankSavedData getData(int id, MinecraftServer server) {
        if (id <= -1) {
            throw new RuntimeException("Invalid frequency: " + id);
        }
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        return (CDankSavedData)overworld.m_8895_().m_164861_(compoundTag -> CDankSavedData.loadStatic(compoundTag, overworld), () -> new CDankSavedData(overworld), "dankstorage/" + id);
    }
}

