/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class JsonQuery {
    @Nullable
    private final JsonElement element;

    JsonQuery(@Nullable JsonElement element) {
        this.element = element;
    }

    JsonQuery() {
        this.element = null;
    }

    public static JsonQuery of(JsonElement element) {
        return new JsonQuery(element);
    }

    public static JsonQuery of(JsonElement element, String path) {
        String[] parts = path.split("/");
        JsonQuery current = JsonQuery.of(element);
        for (String part : parts) {
            current = StringUtils.isNumeric((CharSequence)part) ? current.get(Integer.parseInt(part)) : current.get(part);
        }
        return current;
    }

    public JsonQuery get(String identifier) {
        JsonObject json;
        JsonElement child;
        JsonElement jsonElement = this.element;
        if (jsonElement instanceof JsonObject && (child = (json = (JsonObject)jsonElement).get(identifier)) != null) {
            return new JsonQuery(child);
        }
        return new JsonQuery();
    }

    public JsonQuery get(int index) {
        JsonElement jsonElement = this.element;
        if (jsonElement instanceof JsonArray) {
            JsonElement child;
            JsonArray json = (JsonArray)jsonElement;
            if (index >= 0 && index < json.size() && (child = json.get(index)) != null) {
                return new JsonQuery(child);
            }
        }
        return new JsonQuery();
    }

    public JsonQuery get(String identifier, int index) {
        return this.get(identifier).get(index);
    }

    public Optional<JsonElement> asElement() {
        return Optional.ofNullable(this.element);
    }

    public Optional<JsonObject> asObject() {
        return this.asElement().filter(JsonObject.class::isInstance).map(JsonObject.class::cast);
    }

    public Optional<JsonArray> asArray() {
        return this.asElement().filter(JsonArray.class::isInstance).map(JsonArray.class::cast);
    }

    public Optional<String> asString() {
        return this.asElement().filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString);
    }

    public Optional<Integer> asInt() {
        return this.asElement().filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsJsonPrimitive).filter(JsonPrimitive::isNumber).map(JsonElement::getAsInt);
    }

    public JsonQuery shallowCopy() {
        if (this.element == null) {
            return new JsonQuery();
        }
        JsonElement jsonElement = this.element;
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            JsonObject copyObject = new JsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                copyObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            return new JsonQuery((JsonElement)copyObject);
        }
        throw new UnsupportedOperationException();
    }
}

