/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record SkyblockDataUpdateMessage(SkyblockSavedData data, UUID player) {

    public static class Serializer
    implements PacketSerializer<SkyblockDataUpdateMessage> {
        public Class<SkyblockDataUpdateMessage> messageClass() {
            return SkyblockDataUpdateMessage.class;
        }

        public void encode(SkyblockDataUpdateMessage msg, FriendlyByteBuf buffer) {
            CompoundTag tag = msg.data.m_7176_(new CompoundTag());
            if (tag.m_128441_("MetaInformation")) {
                SkyMeta meta = null;
                for (Tag inbt : tag.m_128437_("MetaInformation", 10)) {
                    CompoundTag mtag = (CompoundTag)inbt;
                    UUID player = mtag.m_128342_("Player");
                    if (!msg.player.equals(player)) continue;
                    meta = SkyMeta.get(msg.data, mtag.m_128469_("Meta"));
                    break;
                }
                tag.m_128473_("MetaInformation");
                if (meta != null) {
                    ListTag metaInfo = new ListTag();
                    CompoundTag playerMeta = new CompoundTag();
                    playerMeta.m_128362_("Player", msg.player);
                    playerMeta.m_128365_("Meta", (Tag)meta.save());
                    metaInfo.add((Object)playerMeta);
                    tag.m_128365_("MetaInformation", (Tag)metaInfo);
                }
            }
            buffer.m_130079_(tag);
            buffer.m_130077_(msg.player);
        }

        public SkyblockDataUpdateMessage decode(FriendlyByteBuf buffer) {
            SkyblockSavedData data = new SkyblockSavedData();
            data.load(Objects.requireNonNull(buffer.m_130260_()));
            return new SkyblockDataUpdateMessage(data, buffer.m_130259_());
        }
    }

    public static class Handler
    implements PacketHandler<SkyblockDataUpdateMessage> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(SkyblockDataUpdateMessage msg, Supplier<NetworkEvent.Context> ctx) {
            SkyblockSavedData.updateClient(msg.data);
            return true;
        }
    }
}

