/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import com.mojang.authlib.GameProfile;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.network.DeleteTagsMessage;
import de.melanx.skyblockbuilder.network.ProfilesUpdateMessage;
import de.melanx.skyblockbuilder.network.SaveStructureMessage;
import de.melanx.skyblockbuilder.network.SkyblockDataUpdateMessage;
import de.melanx.skyblockbuilder.network.UpdateTemplateNamesMessage;
import de.melanx.skyblockbuilder.util.RandomUtility;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import org.moddingx.libx.annotation.meta.RemoveIn;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.network.NetworkX;

public class SkyNetwork
extends NetworkX {
    public SkyNetwork() {
        super((ModX)SkyblockBuilder.getInstance());
    }

    protected NetworkX.Protocol getProtocol() {
        return NetworkX.Protocol.of((String)"11");
    }

    protected void registerPackets() {
        this.registerGame(NetworkDirection.PLAY_TO_SERVER, new SaveStructureMessage.Serializer(), () -> SaveStructureMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_SERVER, new DeleteTagsMessage.Serializer(), () -> DeleteTagsMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_CLIENT, new SkyblockDataUpdateMessage.Serializer(), () -> SkyblockDataUpdateMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_CLIENT, new ProfilesUpdateMessage.Serializer(), () -> ProfilesUpdateMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_CLIENT, new UpdateTemplateNamesMessage.Serializer(), () -> UpdateTemplateNamesMessage.Handler::new);
    }

    public void updateData(Level level, SkyblockSavedData data) {
        if (!level.f_46443_) {
            for (ServerPlayer player : ((ServerLevel)level).m_7654_().m_6846_().m_11314_()) {
                this.updateData((Player)player, data);
            }
        }
    }

    public void updateData(Player player, @Nullable SkyblockSavedData data) {
        if (!player.m_20193_().f_46443_) {
            this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new SkyblockDataUpdateMessage(data != null ? data : SkyblockSavedData.get(player.m_20193_()), player.m_36316_().getId()));
        }
    }

    public void deleteTags(ItemStack stack) {
        this.channel.sendToServer((Object)new DeleteTagsMessage(stack));
    }

    @Deprecated(forRemoval=true)
    @RemoveIn(minecraft="1.21")
    public void saveStructure(ItemStack stack, String name, boolean saveToConfig, boolean ignoreAir, boolean asSnbt) {
        this.saveStructure(stack, name, saveToConfig, ignoreAir, asSnbt, false);
    }

    public void saveStructure(ItemStack stack, String name, boolean saveToConfig, boolean ignoreAir, boolean asSnbt, boolean netherValidation) {
        this.channel.sendToServer((Object)new SaveStructureMessage(stack, name, saveToConfig, ignoreAir, asSnbt, netherValidation));
    }

    public void updateProfiles(Player player) {
        if (player.m_20193_().f_46443_) {
            return;
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ProfilesUpdateMessage(this.getProfilesTag((ServerLevel)player.m_20193_())));
    }

    public void updateProfiles(Level level) {
        if (level.f_46443_) {
            return;
        }
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)new ProfilesUpdateMessage(this.getProfilesTag((ServerLevel)level)));
    }

    public void updateTemplateNames(Player player, List<String> names) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateTemplateNamesMessage(names));
    }

    public void updateTemplateNames(List<String> names) {
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)new UpdateTemplateNamesMessage(names));
    }

    private CompoundTag getProfilesTag(ServerLevel level) {
        Set<GameProfile> profileCache = RandomUtility.getGameProfiles(level);
        CompoundTag profiles = new CompoundTag();
        ListTag tags = new ListTag();
        profileCache.forEach(profile -> {
            if (profile.getId() != null && profile.getName() != null) {
                CompoundTag tag = new CompoundTag();
                tag.m_128362_("Id", profile.getId());
                tag.m_128359_("Name", profile.getName());
                tags.add((Object)tag);
            }
        });
        profiles.m_128365_("Profiles", (Tag)tags);
        return profiles;
    }
}

