/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import com.mojang.authlib.GameProfile;
import de.melanx.skyblockbuilder.client.GameProfileCache;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record ProfilesUpdateMessage(CompoundTag profiles) {

    public static class Serializer
    implements PacketSerializer<ProfilesUpdateMessage> {
        public Class<ProfilesUpdateMessage> messageClass() {
            return ProfilesUpdateMessage.class;
        }

        public void encode(ProfilesUpdateMessage msg, FriendlyByteBuf buffer) {
            buffer.m_130079_(msg.profiles);
        }

        public ProfilesUpdateMessage decode(FriendlyByteBuf buffer) {
            return new ProfilesUpdateMessage(buffer.m_130260_());
        }
    }

    public static class Handler
    implements PacketHandler<ProfilesUpdateMessage> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(ProfilesUpdateMessage msg, Supplier<NetworkEvent.Context> ctx) {
            HashSet<GameProfile> profiles = new HashSet<GameProfile>();
            for (Tag tag : msg.profiles.m_128437_("Profiles", 10)) {
                CompoundTag nbt = (CompoundTag)tag;
                UUID id = nbt.m_128342_("Id");
                String name = nbt.m_128461_("Name");
                profiles.add(new GameProfile(id, name));
            }
            GameProfileCache.addProfiles(profiles);
            return true;
        }
    }
}

