/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.events;

import de.melanx.skyblockbuilder.data.Team;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.Event;

public abstract class SkyblockManageTeamEvent
extends Event {
    private final ServerPlayer player;
    private final Team team;

    private SkyblockManageTeamEvent(@Nullable ServerPlayer player, Team team) {
        this.player = player;
        this.team = team;
    }

    @Nullable
    public ServerPlayer getPlayer() {
        return this.player;
    }

    public Team getTeam() {
        return this.team;
    }

    public boolean hasResult() {
        return true;
    }

    public static class Leave
    extends SkyblockManageTeamEvent {
        public Leave(@Nonnull ServerPlayer player, Team team) {
            super(player, team);
        }

        @Override
        @Nonnull
        public ServerPlayer getPlayer() {
            return super.getPlayer();
        }
    }

    public static class Rename
    extends SkyblockManageTeamEvent {
        private String newName;

        public Rename(ServerPlayer player, Team team, String newName) {
            super(player, team);
            this.newName = newName;
        }

        public String getNewName() {
            return this.newName;
        }

        public Rename setNewName(String newName) {
            this.newName = newName;
            return this;
        }
    }

    public static class ResetSpawns
    extends SkyblockManageTeamEvent {
        public ResetSpawns(ServerPlayer player, Team team) {
            super(player, team);
        }
    }

    public static class RemoveSpawn
    extends SkyblockManageTeamEvent {
        private final BlockPos pos;

        public RemoveSpawn(@Nonnull ServerPlayer player, Team team, BlockPos pos) {
            super(player, team);
            this.pos = pos;
        }

        @Override
        @Nonnull
        public ServerPlayer getPlayer() {
            return super.getPlayer();
        }

        public BlockPos getPos() {
            return this.pos;
        }
    }

    public static class AddSpawn
    extends SkyblockManageTeamEvent {
        private BlockPos pos;
        private Direction direction;

        public AddSpawn(@Nonnull ServerPlayer player, Team team, BlockPos pos, Direction direction) {
            super(player, team);
            this.pos = pos;
            this.direction = direction;
        }

        @Override
        @Nonnull
        public ServerPlayer getPlayer() {
            return super.getPlayer();
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public AddSpawn setPos(BlockPos pos) {
            this.pos = pos;
            return this;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public AddSpawn setDirection(@Nonnull Direction direction) {
            this.direction = direction;
            return this;
        }
    }

    public static class ToggleRequests
    extends SkyblockManageTeamEvent {
        private boolean allowRequests;

        public ToggleRequests(@Nonnull ServerPlayer player, Team team, boolean allowRequests) {
            super(player, team);
            this.allowRequests = allowRequests;
        }

        public boolean shouldAllowRequests() {
            return this.allowRequests;
        }

        public void setAllowRequests(boolean allowRequests) {
            this.allowRequests = allowRequests;
        }
    }

    public static class ToggleVisits
    extends SkyblockManageTeamEvent {
        private boolean allowVisits;

        public ToggleVisits(@Nonnull ServerPlayer player, Team team, boolean allowVisits) {
            super(player, team);
            this.allowVisits = allowVisits;
        }

        @Override
        @Nonnull
        public ServerPlayer getPlayer() {
            return super.getPlayer();
        }

        public boolean shouldAllowVisits() {
            return this.allowVisits;
        }

        public void setAllowVisits(boolean allowVisits) {
            this.allowVisits = allowVisits;
        }
    }
}

