/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.client.GameProfileCache;
import de.melanx.skyblockbuilder.compat.CadmusCompat;
import de.melanx.skyblockbuilder.config.common.SpawnConfig;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.data.TemplateData;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateInfo;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.Spiral;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyblockbuilder.world.IslandPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.Pair;

public class SkyblockSavedData
extends SavedData {
    private static final String NAME = "skyblock_builder";
    private static SkyblockSavedData clientInstance;
    public static final UUID SPAWN_ID;
    private ServerLevel level;
    private Map<UUID, SkyMeta> metaInfo = Maps.newHashMap();
    private Map<UUID, Team> skyblocks = Maps.newHashMap();
    private BiMap<String, UUID> skyblockIds = HashBiMap.create();
    private BiMap<UUID, IslandPos> skyblockPositions = HashBiMap.create();
    private Spiral spiral = new Spiral();

    public static SkyblockSavedData get(Level level) {
        if (!level.f_46443_) {
            MinecraftServer server = ((ServerLevel)level).m_7654_();
            DimensionDataStorage storage = server.m_129783_().m_8895_();
            SkyblockSavedData data = (SkyblockSavedData)storage.m_164861_(nbt -> new SkyblockSavedData().load((CompoundTag)nbt), SkyblockSavedData::new, NAME);
            data.level = WorldUtil.getConfiguredLevel(server);
            data.getOrCreateMetaInfo(Util.f_137441_);
            return data;
        }
        return clientInstance == null ? new SkyblockSavedData() : clientInstance;
    }

    public static void updateClient(SkyblockSavedData data) {
        clientInstance = data;
    }

    public Team getSpawn() {
        if (this.skyblocks.get(SPAWN_ID) != null) {
            return this.skyblocks.get(SPAWN_ID);
        }
        SkyblockBuilder.getLogger().info("Successfully generated spawn.");
        Team team = this.createTeam("Spawn", TemplatesConfig.spawn.flatMap(templateInfo -> Optional.of(new ConfiguredTemplate((TemplateInfo)templateInfo))).orElse(TemplateData.get(this.level).getConfiguredTemplate()));
        team.addPlayer(Util.f_137441_);
        if (ModList.get().isLoaded("cadmus")) {
            CadmusCompat.protectSpawn(this.level, team);
        }
        this.m_77762_();
        return team;
    }

    public Optional<Team> getSpawnOption() {
        return Optional.ofNullable(this.skyblocks.get(SPAWN_ID));
    }

    public Pair<IslandPos, Team> create(String teamName, ConfiguredTemplate template) {
        Team team;
        IslandPos islandPos;
        if (teamName.equalsIgnoreCase("spawn")) {
            pos = new int[]{0, 0};
            if (SpawnConfig.skipCenterIslandCreation) {
                pos = this.spiral.next();
            }
            islandPos = new IslandPos((Level)this.level, pos[0], pos[1], template);
            team = new Team(this, islandPos, SPAWN_ID);
        } else {
            while (this.skyblockPositions.containsValue((Object)(islandPos = new IslandPos((Level)this.level, (pos = this.spiral.next())[0], pos[1], template)))) {
            }
            team = new Team(this, islandPos);
        }
        Set<TemplatesConfig.Spawn> positions = SkyblockSavedData.initialPossibleSpawns(islandPos.getCenter(), template);
        team.setPossibleSpawns(positions);
        team.setName(teamName);
        this.skyblocks.put(team.getId(), team);
        this.skyblockIds.put((Object)team.getName().toLowerCase(Locale.ROOT), (Object)team.getId());
        this.skyblockPositions.put((Object)team.getId(), (Object)islandPos);
        this.m_77762_();
        return Pair.of((Object)islandPos, (Object)team);
    }

    public SkyblockSavedData load(CompoundTag nbt) {
        CompoundTag tag;
        HashMap metaInfo = Maps.newHashMap();
        HashMap skyblocks = Maps.newHashMap();
        HashBiMap skyblockIds = HashBiMap.create();
        HashBiMap skyblockPositions = HashBiMap.create();
        for (Tag inbt : nbt.m_128437_("Islands", 10)) {
            tag = (CompoundTag)inbt;
            IslandPos island = IslandPos.fromTag(tag.m_128469_("Island"));
            Team team = Team.create(this, tag);
            skyblocks.put(team.getId(), team);
            skyblockIds.put((Object)team.getName().toLowerCase(Locale.ROOT), (Object)team.getId());
            skyblockPositions.put((Object)team.getId(), (Object)island);
        }
        for (Tag inbt : nbt.m_128437_("MetaInformation", 10)) {
            tag = (CompoundTag)inbt;
            UUID player = tag.m_128342_("Player");
            SkyMeta meta = SkyMeta.get(this, tag.m_128469_("Meta"));
            metaInfo.put(player, meta);
        }
        this.metaInfo = metaInfo;
        this.skyblocks = skyblocks;
        this.skyblockIds = skyblockIds;
        this.skyblockPositions = skyblockPositions;
        this.spiral = Spiral.fromArray(nbt.m_128465_("SpiralState"));
        return this;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        ListTag islands = new ListTag();
        for (Team team : this.skyblocks.values()) {
            islands.add((Object)team.serializeNBT());
        }
        ListTag metaInfo = new ListTag();
        for (Map.Entry<UUID, SkyMeta> entry : this.metaInfo.entrySet()) {
            SkyMeta meta = entry.getValue();
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128362_("Player", entry.getKey());
            entryTag.m_128365_("Meta", (Tag)meta.save());
            metaInfo.add((Object)entryTag);
        }
        compound.m_128385_("SpiralState", this.spiral.toIntArray());
        compound.m_128365_("Islands", (Tag)islands);
        compound.m_128365_("MetaInformation", (Tag)metaInfo);
        return compound;
    }

    @Nullable
    public IslandPos getTeamIsland(UUID teamId) {
        return (IslandPos)this.skyblockPositions.get((Object)teamId);
    }

    public boolean hasPlayerTeam(Player player) {
        return this.hasPlayerTeam(player.m_36316_().getId());
    }

    public boolean hasPlayerTeam(UUID player) {
        Team team = this.getTeamFromPlayer(player);
        return team != null && !team.isSpawn();
    }

    public boolean addPlayerToTeam(UUID teamId, Player player) {
        return this.addPlayerToTeam(teamId, player.m_36316_().getId());
    }

    public boolean addPlayerToTeam(UUID teamId, UUID playerId) {
        Team team = this.skyblocks.get(teamId);
        if (team != null) {
            return team.addPlayer(playerId);
        }
        return false;
    }

    public boolean addPlayerToTeam(String teamName, Player player) {
        return this.addPlayerToTeam(teamName, player.m_36316_().getId());
    }

    public boolean addPlayerToTeam(String teamName, UUID player) {
        UUID teamId = (UUID)this.skyblockIds.get((Object)teamName.toLowerCase(Locale.ROOT));
        return this.addPlayerToTeam(teamId, player);
    }

    public boolean addPlayerToTeam(Team team, Player player) {
        return this.addPlayerToTeam(team, player.m_36316_().getId());
    }

    public boolean addPlayerToTeam(Team team, UUID player) {
        ServerPlayer onlinePlayer;
        ServerLevel level;
        if (!team.isSpawn()) {
            team.broadcast(Component.m_237110_((String)"skyblockbuilder.event.player_joined", (Object[])new Object[]{GameProfileCache.getName(player)}), Style.f_131099_.m_131157_(ChatFormatting.GOLD));
        }
        if (!((level = team.getLevel()) == null || this.metaInfo.get(player).getPreviousTeamIds().contains(team.getId()) || (onlinePlayer = level.m_7654_().m_6846_().m_11259_(player)) == null || !TemplatesConfig.spawn.isEmpty() && team.isSpawn())) {
            RandomUtility.setStartInventory(onlinePlayer);
        }
        this.getSpawn().removePlayer(player);
        team.addPlayer(player);
        this.m_77762_();
        return true;
    }

    @Nullable
    public Team createTeam(String teamName) {
        if (this.level == null) {
            return null;
        }
        return this.createTeam(teamName, TemplateData.get(this.level).getConfiguredTemplate());
    }

    @Nullable
    public Team createTeam(String teamName, ConfiguredTemplate template) {
        if (this.teamExists(teamName) || this.level == null) {
            return null;
        }
        Pair<IslandPos, Team> pair = this.create(teamName, template);
        Team team = (Team)pair.getRight();
        ArrayList<TemplatesConfig.Spawn> possibleSpawns = new ArrayList<TemplatesConfig.Spawn>(this.getPossibleSpawns(team.getIsland(), template));
        team.setPossibleSpawns(possibleSpawns);
        BlockPos center = team.getIsland().getCenter();
        template.placeInWorld(this.level, team, TemplateLoader.STRUCTURE_PLACE_SETTINGS, RandomSource.m_216327_(), 2);
        SkyblockSavedData.surround(this.level, center, template);
        this.skyblocks.put(team.getId(), team);
        this.skyblockIds.put((Object)team.getName().toLowerCase(Locale.ROOT), (Object)team.getId());
        this.skyblockPositions.put((Object)team.getId(), (Object)team.getIsland());
        SkyblockBuilder.getLogger().info("Created team {} ({}) at {} with template {}", new Object[]{team.getName(), team.getId(), center, template.getName()});
        this.m_77762_();
        return team;
    }

    @Nullable
    public Team createTeamAndJoin(String teamName, Player player) {
        return this.createTeamAndJoin(teamName, player.m_36316_().getId());
    }

    @Nullable
    public Team createTeamAndJoin(String teamName, UUID player) {
        Team team = this.createTeam(teamName);
        if (team == null) {
            return null;
        }
        team.addPlayer(player);
        this.m_77762_();
        return team;
    }

    public boolean removePlayerFromTeam(Player player) {
        return this.removePlayerFromTeam(player.m_36316_().getId());
    }

    public boolean removePlayerFromTeam(UUID player) {
        for (Map.Entry<UUID, Team> entry : this.skyblocks.entrySet()) {
            Team team = entry.getValue();
            if (team.isSpawn() || !team.hasPlayer(player)) continue;
            boolean removed = team.removePlayer(player);
            if (removed) {
                team.broadcast(Component.m_237110_((String)"skyblockbuilder.event.remove_player", (Object[])new Object[]{GameProfileCache.getName(player)}), Style.f_131099_.m_131157_(ChatFormatting.RED));
                this.getTeam(SPAWN_ID).addPlayer(player);
                this.getOrCreateMetaInfo(player).setTeamId(SPAWN_ID);
            }
            return removed;
        }
        return false;
    }

    public void removeAllPlayersFromTeam(@Nonnull Team team) {
        HashSet players = Sets.newHashSet(team.getPlayers());
        team.removeAllPlayers();
        Team spawn = this.getSpawn();
        for (UUID player : players) {
            this.addPlayerToTeam(spawn, player);
        }
        this.m_77762_();
    }

    @Nullable
    public Team getTeam(String name) {
        return this.getTeam((UUID)this.skyblockIds.get((Object)name.toLowerCase(Locale.ROOT)));
    }

    @Nullable
    public Team getTeam(UUID teamId) {
        return this.skyblocks.get(teamId);
    }

    public boolean deleteTeam(String team) {
        UUID teamId = (UUID)this.skyblockIds.get((Object)team.toLowerCase(Locale.ROOT));
        return this.deleteTeam(teamId);
    }

    public boolean deleteTeam(UUID teamId) {
        Team removedTeam = this.skyblocks.remove(teamId);
        if (removedTeam == null) {
            return false;
        }
        this.skyblockIds.inverse().remove((Object)teamId);
        this.skyblockPositions.inverse().remove((Object)removedTeam.getIsland());
        this.skyblocks.get(SPAWN_ID).addPlayers(removedTeam.getPlayers());
        return true;
    }

    @Nullable
    public Team getTeamFromPlayer(Player player) {
        return this.getTeamFromPlayer(player.m_36316_().getId());
    }

    @Nullable
    public Team getTeamFromPlayer(UUID player) {
        SkyMeta meta = this.metaInfo.get(player);
        if (meta == null) {
            return null;
        }
        Team team = this.skyblocks.getOrDefault(meta.getTeamId(), this.skyblocks.get(SPAWN_ID));
        return team == null || team.isSpawn() ? null : team;
    }

    public boolean teamExists(String name) {
        return this.skyblockIds.containsKey((Object)name.toLowerCase(Locale.ROOT));
    }

    public boolean teamExists(UUID teamId) {
        return this.skyblocks.containsKey(teamId);
    }

    public Collection<Team> getTeams() {
        return this.skyblocks.values();
    }

    public void addInvite(Team team, Player invitor, Player player) {
        this.addInvite(team, invitor, player.m_36316_().getId());
    }

    public void addInvite(Team team, Player invitor, UUID id) {
        SkyMeta meta = this.metaInfo.get(id);
        if (!meta.getInvites().contains(team.getId())) {
            meta.addInvite(team.getId());
            team.broadcast(Component.m_237110_((String)"skyblockbuilder.event.invite_player", (Object[])new Object[]{invitor.m_5446_(), GameProfileCache.getName(id)}), Style.f_131099_.m_131157_(ChatFormatting.GOLD));
        }
        this.m_77762_();
    }

    public boolean hasInvites(Player player) {
        return this.hasInvites(player.m_36316_().getId());
    }

    public boolean hasInvites(UUID player) {
        SkyMeta meta = this.metaInfo.get(player);
        return meta != null && !meta.getInvites().isEmpty();
    }

    public boolean hasInviteFrom(Team team, Player player) {
        return this.hasInviteFrom(team, player.m_36316_().getId());
    }

    public boolean hasInviteFrom(Team team, UUID player) {
        SkyMeta meta = this.metaInfo.get(player);
        return meta != null && meta.getInvites().contains(team.getId());
    }

    public List<UUID> getInvites(Player player) {
        return this.getInvites(player.m_36316_().getId());
    }

    public List<UUID> getInvites(UUID player) {
        SkyMeta meta = this.metaInfo.get(player);
        return meta == null ? Lists.newArrayList() : meta.getInvites();
    }

    public boolean acceptInvite(Team team, Player player) {
        return this.acceptInvite(team, player.m_36316_().getId());
    }

    public boolean acceptInvite(Team team, UUID id) {
        SkyMeta meta = this.metaInfo.get(id);
        if (meta == null) {
            return false;
        }
        if (meta.getInvites().contains(team.getId())) {
            team.broadcast(Component.m_237110_((String)"skyblockbuilder.event.accept_invite", (Object[])new Object[]{GameProfileCache.getName(id)}), Style.f_131099_.m_131157_(ChatFormatting.GOLD));
            this.addPlayerToTeam(team.getName(), id);
            meta.resetInvites();
            WorldUtil.teleportToIsland(this.level.m_7654_().m_6846_().m_11259_(id), team);
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean declineInvite(Team team, Player player) {
        return this.declineInvite(team, player.m_36316_().getId());
    }

    public boolean declineInvite(Team team, UUID id) {
        SkyMeta meta = this.metaInfo.get(id);
        if (meta == null) {
            return false;
        }
        meta.removeInvite(team.getId());
        this.m_77762_();
        return true;
    }

    public void renameTeam(Team team, @Nullable ServerPlayer player, String name) {
        String oldName = team.getName().toLowerCase();
        this.skyblockIds.remove((Object)oldName);
        team.setName(name);
        this.skyblockIds.put((Object)name.toLowerCase(Locale.ROOT), (Object)team.getId());
        Component playerName = player != null ? player.m_5446_() : Component.m_237113_((String)"Server");
        team.broadcast(Component.m_237110_((String)"skyblockbuilder.event.rename_team", (Object[])new Object[]{playerName, oldName, name}), Style.f_131099_.m_131157_(ChatFormatting.DARK_RED));
        this.m_77762_();
    }

    public SkyMeta getOrCreateMetaInfo(Player player) {
        return this.getOrCreateMetaInfo(player.m_36316_().getId());
    }

    public SkyMeta getOrCreateMetaInfo(UUID id) {
        return this.metaInfo.computeIfAbsent(id, meta -> new SkyMeta(this, id));
    }

    public Set<TemplatesConfig.Spawn> getPossibleSpawns(IslandPos pos, ConfiguredTemplate template) {
        if (!this.skyblockPositions.containsValue((Object)pos)) {
            return SkyblockSavedData.initialPossibleSpawns(pos.getCenter(), template);
        }
        return this.skyblocks.get(this.skyblockPositions.inverse().get((Object)pos)).getPossibleSpawns();
    }

    public static Set<TemplatesConfig.Spawn> initialPossibleSpawns(BlockPos center, ConfiguredTemplate template) {
        HashSet<TemplatesConfig.Spawn> positions = new HashSet<TemplatesConfig.Spawn>();
        for (TemplatesConfig.Spawn spawn : template.getDefaultSpawns()) {
            positions.add(new TemplatesConfig.Spawn(center.m_121955_((Vec3i)spawn.pos().m_7949_()), spawn.direction()));
        }
        return positions;
    }

    public static void surround(ServerLevel level, BlockPos zero, ConfiguredTemplate configuredTemplate) {
        if (configuredTemplate.getSurroundingBlocks().isEmpty() || configuredTemplate.getSurroundingMargin() <= 0) {
            return;
        }
        StructureTemplate template = configuredTemplate.getTemplate();
        BoundingBox box = new BoundingBox(zero.m_123341_(), zero.m_123342_(), zero.m_123343_(), zero.m_123341_() + template.f_74484_.m_123341_() - 1, zero.m_123342_() + template.f_74484_.m_123342_() - 1, zero.m_123343_() + template.f_74484_.m_123343_() - 1);
        BoundingBox outside = box.m_191961_(configuredTemplate.getSurroundingMargin());
        RandomSource random = RandomSource.m_216327_();
        BlockPos.m_121919_((BoundingBox)outside).forEach(blockPos -> {
            if (!box.m_71051_((Vec3i)blockPos)) {
                Block block = configuredTemplate.getSurroundingBlocks().get(random.m_188503_(configuredTemplate.getSurroundingBlocks().size()));
                level.m_7731_(blockPos, block.m_49966_(), 2);
            }
        });
    }

    public void m_77762_() {
        super.m_77762_();
        if (this.level != null) {
            SkyblockBuilder.getNetwork().updateData((Level)this.level, this);
            for (ServerPlayer player : this.level.m_7654_().m_6846_().m_11314_()) {
                player.refreshTabListName();
            }
        }
    }

    public void setDirtySilently() {
        super.m_77762_();
    }

    @Nullable
    public ServerLevel getLevel() {
        return this.level;
    }

    static {
        SPAWN_ID = Util.f_137441_;
    }
}

