/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.mapper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.template.TemplateInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;
import org.moddingx.libx.impl.config.ModMappers;
import org.moddingx.libx.impl.config.mappers.special.RecordValueMapper;

public class TemplateInfoMapper
implements ValueMapper<TemplateInfo, JsonObject> {
    public Class<TemplateInfo> type() {
        return TemplateInfo.class;
    }

    public Class<JsonObject> element() {
        return JsonObject.class;
    }

    public TemplateInfo fromJson(JsonObject json) {
        String name = json.get("name").getAsString();
        String file = json.get("file").getAsString();
        String spawns = json.get("spawns").getAsString();
        String desc = "";
        if (json.has("desc")) {
            desc = json.get("desc").getAsString();
        }
        TemplateInfo.Offset offset = new TemplateInfo.Offset(WorldConfig.offset, 0, WorldConfig.offset);
        if (json.has("offset")) {
            JsonArray offsetArray = json.get("offset").getAsJsonArray();
            offset = new TemplateInfo.Offset(offsetArray.get(0).getAsInt(), offsetArray.get(1).getAsInt(), offsetArray.get(2).getAsInt());
        } else if (WorldConfig.offset != 0) {
            offset = new TemplateInfo.Offset(WorldConfig.offset, 0, WorldConfig.offset);
        }
        String surroundingBlocks = "";
        if (json.has("surroundingBlocks")) {
            surroundingBlocks = json.get("surroundingBlocks").getAsString();
        }
        int surroundingMargin = 0;
        if (json.has("surroundingMargin")) {
            surroundingMargin = json.get("surroundingMargin").getAsInt();
        }
        String spreads = "";
        if (json.has("spreads")) {
            spreads = json.get("spreads").getAsString();
        }
        return new TemplateInfo(name, desc, file, spawns, offset, surroundingBlocks, spreads, surroundingMargin);
    }

    public JsonObject toJson(TemplateInfo templateInfo) {
        JsonObject json = new JsonObject();
        json.addProperty("name", templateInfo.name());
        if (!templateInfo.desc().isBlank()) {
            json.addProperty("desc", templateInfo.desc());
        }
        json.addProperty("file", templateInfo.file());
        json.addProperty("spawns", templateInfo.spawns());
        if (templateInfo.offset().x() != WorldConfig.offset || templateInfo.offset().z() != WorldConfig.offset) {
            JsonArray offsetArray = new JsonArray();
            offsetArray.add((Number)templateInfo.offset().x());
            offsetArray.add((Number)templateInfo.offset().y());
            offsetArray.add((Number)templateInfo.offset().z());
            json.add("offset", (JsonElement)offsetArray);
        }
        if (!templateInfo.surroundingBlocks().isEmpty()) {
            json.addProperty("surroundingBlocks", templateInfo.surroundingBlocks());
        }
        if (templateInfo.surroundingMargin() > 0) {
            json.addProperty("surroundingMargin", (Number)templateInfo.surroundingMargin());
        }
        if (!templateInfo.spreads().isEmpty()) {
            json.addProperty("spreads", templateInfo.spreads());
        }
        return json;
    }

    public ConfigEditor<TemplateInfo> createEditor(ValidatorInfo<?> validator) {
        try {
            Method method = ModMappers.class.getDeclaredMethod("getMapper", Type.class);
            method.setAccessible(true);
            ModMappers modMappers = ModMappers.get((String)SkyblockBuilder.getInstance().modid);
            return new RecordValueMapper(SkyblockBuilder.getInstance().modid, TemplateInfo.class, type -> {
                try {
                    return (ValueMapper)method.invoke((Object)modMappers, type);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }).createEditor(validator);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

