/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.mapper;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.moddingx.libx.config.correct.ConfigCorrection;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.InputProperties;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;

public class ResourceKeyMapper
implements ValueMapper<ResourceKey<Level>, JsonPrimitive> {
    private static final InputProperties<ResourceKey<Level>> INPUT = new InputProperties<ResourceKey<Level>>(){

        public ResourceKey<Level> defaultValue() {
            return ResourceKeyMapper.getResourceKey("overworld");
        }

        public boolean canInputChar(char chr) {
            return ResourceLocation.m_135816_((char)chr);
        }

        public boolean isValid(String str) {
            return ResourceLocation.m_135820_((String)str) != null;
        }

        public ResourceKey<Level> valueOf(String str) {
            return ResourceKeyMapper.getResourceKey(str);
        }

        public String toString(ResourceKey<Level> levelResourceKey) {
            return levelResourceKey.m_135782_().toString();
        }
    };

    public ResourceKey<Level> fromJson(JsonPrimitive json) {
        return ResourceKeyMapper.getResourceKey(json.getAsString());
    }

    public JsonPrimitive toJson(ResourceKey<Level> value) {
        return new JsonPrimitive(value.m_135782_().toString());
    }

    public ResourceKey<Level> fromNetwork(FriendlyByteBuf buffer) {
        return ResourceKeyMapper.getResourceKey(buffer.m_130281_());
    }

    public void toNetwork(ResourceKey<Level> value, FriendlyByteBuf buffer) {
        buffer.m_130085_(value.m_135782_());
    }

    public ConfigEditor<ResourceKey<Level>> createEditor(ValidatorInfo<?> validator) {
        return ConfigEditor.input(INPUT, validator);
    }

    public Class<ResourceKey<Level>> type() {
        return ResourceKey.class;
    }

    public Class<JsonPrimitive> element() {
        return JsonPrimitive.class;
    }

    public Optional<ResourceKey<Level>> correct(JsonElement json, ConfigCorrection<ResourceKey<Level>> correction) {
        return super.correct(json, correction);
    }

    private static ResourceKey<Level> getResourceKey(String str) {
        return ResourceKeyMapper.getResourceKey(new ResourceLocation(str));
    }

    private static ResourceKey<Level> getResourceKey(ResourceLocation location) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)location);
    }
}

