/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.mapper;

import com.google.gson.JsonPrimitive;
import de.melanx.skyblockbuilder.template.NetherPortalTemplate;
import de.melanx.skyblockbuilder.util.SkyPaths;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.InputProperties;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;

public class NetherPortalTemplateMapper
implements ValueMapper<NetherPortalTemplate, JsonPrimitive> {
    private static final InputProperties<NetherPortalTemplate> DEFAULT_PROPERTIES = new InputProperties<NetherPortalTemplate>(){

        public NetherPortalTemplate defaultValue() {
            return new NetherPortalTemplate("default.nbt");
        }

        public NetherPortalTemplate valueOf(String str) {
            return new NetherPortalTemplate(str);
        }

        public String toString(NetherPortalTemplate str) {
            return str.getFilePath();
        }

        public boolean isValid(String str) {
            return SkyPaths.NBT_OR_SNBT.test(SkyPaths.TEMPLATES_DIR.resolve(str).toFile());
        }
    };

    public Class<NetherPortalTemplate> type() {
        return NetherPortalTemplate.class;
    }

    public Class<JsonPrimitive> element() {
        return JsonPrimitive.class;
    }

    public NetherPortalTemplate fromJson(JsonPrimitive json) {
        return new NetherPortalTemplate(json.getAsString());
    }

    public JsonPrimitive toJson(NetherPortalTemplate value) {
        return new JsonPrimitive(value.getFilePath());
    }

    public ConfigEditor<NetherPortalTemplate> createEditor(ValidatorInfo<?> validator) {
        return ConfigEditor.input(DEFAULT_PROPERTIES, validator);
    }
}

