/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.common;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.world.level.Level;
import org.moddingx.libx.config.Config;
import org.moddingx.libx.config.validate.IntRange;
import org.moddingx.libx.util.data.ResourceList;

public class WorldConfig {
    @Config(value={"A list of biomes for each dimension.", "You can not use this for the end dimension. The end dimension will always have it's five biomes.", "Overworld has all oceans by default because animals cannot spawn in these biomes.", "These are resource lists. See https://moddingx.org/libx/org/moddingx/libx/util/data/ResourceList.html#use_resource_lists_in_configs"})
    public static Map<String, ResourceList> biomes = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(Level.f_46428_.m_135782_().toString(), new ResourceList(false, b -> b.parse("minecraft:*ocean*")));
        map.put(Level.f_46429_.m_135782_().toString(), ResourceList.DENY_LIST);
    });
    @Config(value={"Should a surface be generated in the dimensions? [default: false]"})
    public static boolean surface = false;
    @Config(value={"The block settings for generating the different dimensions surfaces.", "Same format as flat world generation settings (blocks only)"})
    public static Map<String, String> surfaceSettings = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(Level.f_46428_.m_135782_().toString(), "minecraft:bedrock,2*minecraft:dirt,minecraft:grass_block");
        map.put(Level.f_46429_.m_135782_().toString(), "");
        map.put(Level.f_46430_.m_135782_().toString(), "");
    });
    @Config
    public static Map<String, ResourceList> carvers = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(Level.f_46428_.m_135782_().toString(), ResourceList.ALLOW_LIST);
        map.put(Level.f_46429_.m_135782_().toString(), ResourceList.ALLOW_LIST);
        map.put(Level.f_46430_.m_135782_().toString(), ResourceList.ALLOW_LIST);
    });
    @Config(value={"Sea level in world [default: 63]"})
    public static int seaHeight = 63;
    @Config(value={"Distance between islands in overworld [default: 8192]", "nether the distance is 1/8"})
    @IntRange(min=64, max=29999900)
    public static int islandDistance = 8192;
    @Config(value={"The offset from 0, 0 to generate the islands", "Can be used to generate them in the middle of .mca files"})
    public static int offset = 0;
    @Config(value={"Prevent scheduled ticks after generating the island"})
    public static boolean preventScheduledTicks = true;
    @Config(value={"If a player is leaving a team, it will teleported to overworld spawn instead of spawn island."})
    public static boolean leaveToOverworld = false;
}

