/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.compat.heracles;

import de.melanx.skyblockbuilder.compat.heracles.SpreadLocationTask;
import de.melanx.skyblockbuilder.compat.heracles.SpreadPredicate;
import de.melanx.skyblockbuilder.util.SkyPaths;
import earth.terrarium.heracles.api.CustomizableQuestElement;
import earth.terrarium.heracles.api.client.settings.CustomizableQuestElementSettings;
import earth.terrarium.heracles.api.client.settings.Setting;
import earth.terrarium.heracles.api.client.settings.SettingInitializer;
import earth.terrarium.heracles.api.quests.QuestIcon;
import earth.terrarium.heracles.client.widgets.boxes.AutocompleteEditBox;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import org.jetbrains.annotations.Nullable;

public class SpreadTaskSettings
implements SettingInitializer<SpreadLocationTask>,
CustomizableQuestElementSettings<SpreadLocationTask> {
    public static final SpreadTaskSettings INSTANCE = new SpreadTaskSettings();
    private static final MyAutocompleteTextSetting SPREAD_SETTING = new MyAutocompleteTextSetting(() -> {
        try {
            return Files.list(SkyPaths.SPREADS_DIR).filter(s -> s.toString().endsWith(".nbt") || s.toString().endsWith(".snbt")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(s -> {
                String fileName = SkyPaths.SPREADS_DIR.relativize((Path)s).toString();
                int extensionMarker = fileName.lastIndexOf(46);
                if (extensionMarker > 0) {
                    fileName = fileName.substring(0, extensionMarker);
                }
                return fileName;
            }).toList();
        }
        catch (IOException e) {
            return new ArrayList();
        }
    }, (text, item) -> {
        String[] keywords;
        for (String keyword : keywords = text.split("\\|")) {
            if (!item.toLowerCase(Locale.ROOT).contains(keyword.toLowerCase(Locale.ROOT)) || item.equalsIgnoreCase(keyword)) continue;
            return true;
        }
        return false;
    }, s -> s.contains("|") ? s : s.strip());

    public SettingInitializer.CreationData create(@Nullable SpreadLocationTask task) {
        SettingInitializer.CreationData data = super.create((CustomizableQuestElement)task);
        data.put("spread", (Setting)SPREAD_SETTING, (Object)(task == null ? "" : String.join((CharSequence)"|", task.predicate().getSpreads())));
        return data;
    }

    public SpreadLocationTask create(String id, SpreadLocationTask task, SettingInitializer.Data data) {
        return (SpreadLocationTask)this.create(task, data, (title, icon) -> {
            String[] spreads = data.get("spread", (Setting)SPREAD_SETTING).orElse("").split("\\|");
            SpreadPredicate predicate = spreads.length == 0 ? SpreadPredicate.ALWAYS_TRUE : SpreadPredicate.create(Arrays.asList(spreads));
            return new SpreadLocationTask(id, (String)title, (QuestIcon<?>)icon, predicate);
        });
    }

    private record MyAutocompleteTextSetting(Supplier<List<String>> suggestions, BiPredicate<String, String> filter, Function<String, String> mapper) implements Setting<String, AutocompleteEditBox<String>>
    {
        public AutocompleteEditBox<String> createWidget(int width, String value) {
            MyAutocompleteEditBox box = new MyAutocompleteEditBox(Minecraft.m_91087_().f_91062_, 0, 0, width, 11, this.filter, this.mapper, s -> {});
            box.setSuggestions((Collection<String>)this.suggestions.get());
            box.m_94144_(this.mapper.apply(value));
            box.m_94199_(Short.MAX_VALUE);
            return box;
        }

        public String getValue(AutocompleteEditBox<String> widget) {
            return (String)widget.value();
        }
    }

    private static class MyAutocompleteEditBox
    extends AutocompleteEditBox<String> {
        private final List<String> suggestions = new ArrayList<String>();
        private final Function<String, String> mapper;

        public MyAutocompleteEditBox(Font font, int x, int y, int width, int height, BiPredicate<String, String> filter, Function<String, String> mapper, Consumer<String> onEnter) {
            super(font, x, y, width, height, filter, mapper, onEnter);
            this.mapper = mapper;
        }

        public void setSuggestions(Collection<String> suggestions) {
            super.setSuggestions(suggestions);
            this.suggestions.clear();
            this.suggestions.addAll(suggestions);
            this.filter();
        }

        public String value() {
            String text = this.m_94155_();
            String[] parts = text.split("\\|");
            HashSet<String> toKeep = new HashSet<String>();
            block0: for (String part : parts) {
                for (String suggestion : this.suggestions) {
                    if (!this.mapper.apply(suggestion).equals(part.strip())) continue;
                    toKeep.add(part);
                    continue block0;
                }
            }
            if (toKeep.isEmpty()) {
                return null;
            }
            return String.join((CharSequence)"|", toKeep);
        }
    }
}

