/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder;

import de.melanx.skyblockbuilder.config.common.SpawnConfig;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnProtectionEvents {
    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        if (SpawnProtectionEvents.isOnSpawn((Entity)event.getEntity()) && !event.getEntity().m_20310_(2)) {
            PlayerInteractEvent.EntityInteract entityInteract;
            if (event instanceof PlayerInteractEvent.EntityInteract && (SpawnConfig.interactionEntitiesInSpawnProtection.test(ForgeRegistries.ENTITY_TYPES.getKey((Object)(entityInteract = (PlayerInteractEvent.EntityInteract)event).getTarget().m_6095_())) || SpawnProtectionEvents.ignore(Type.INTERACT_ENTITIES))) {
                return;
            }
            if (event.isCancelable() && !SpawnProtectionEvents.ignore(Type.INTERACT_BLOCKS)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void mobGrief(EntityMobGriefingEvent event) {
        if (SpawnProtectionEvents.ignore(Type.MOB_GRIEFING)) {
            return;
        }
        if (event.getEntity() != null && event.getEntity().m_9236_() != null && event.getEntity().m_9236_().m_46472_() != null && SpawnProtectionEvents.isOnSpawn(event.getEntity())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void explode(ExplosionEvent.Start event) {
        if (SpawnProtectionEvents.ignore(Type.EXPLOSIONS)) {
            return;
        }
        Vec3 position = event.getExplosion().getPosition();
        if (SpawnProtectionEvents.isOnSpawn(event.getLevel(), new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        if (SpawnProtectionEvents.ignore(Type.INTERACT_BLOCKS)) {
            return;
        }
        if (SpawnProtectionEvents.isOnSpawn((Entity)event.getPlayer()) && !event.getPlayer().m_20310_(2)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void blockPlace(BlockEvent.EntityPlaceEvent event) {
        Level level;
        if (SpawnProtectionEvents.ignore(Type.INTERACT_BLOCKS)) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && SpawnProtectionEvents.isOnSpawn(level = (Level)levelAccessor, event.getPos()) && (!(event.getEntity() instanceof Player) || !event.getEntity().m_20310_(2))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void farmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (SpawnProtectionEvents.ignore(Type.MOB_GRIEFING)) {
            return;
        }
        if (SpawnProtectionEvents.isOnSpawn(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void cropGrow(BlockEvent.CropGrowEvent.Pre event) {
        Level level;
        if (SpawnProtectionEvents.ignore(Type.CROP_GROW)) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && SpawnProtectionEvents.isOnSpawn(level = (Level)levelAccessor, event.getPos())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void cropGrow(BlockEvent.BlockToolModificationEvent event) {
        if (SpawnProtectionEvents.ignore(Type.CROP_GROW)) {
            return;
        }
        if (SpawnProtectionEvents.isOnSpawn(event.getContext().m_43725_(), event.getPos()) && (event.getPlayer() == null || !event.getPlayer().m_20310_(2))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void applyBonemeal(BonemealEvent event) {
        if (SpawnProtectionEvents.ignore(Type.APPLY_BONEMEAL)) {
            return;
        }
        if (SpawnProtectionEvents.isOnSpawn(event.getLevel(), event.getPos()) && (event.getEntity() == null || !event.getEntity().m_20310_(2))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void mobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (SpawnProtectionEvents.ignore(Type.MOBS_SPAWN_EGG)) {
            return;
        }
        Level level = event.getLevel() instanceof Level ? (Level)event.getLevel() : event.getEntity().m_9236_();
        if (level != null && SpawnProtectionEvents.isOnSpawn((Entity)event.getEntity()) && event.getSpawnType() != MobSpawnType.SPAWN_EGG && event.getSpawnType() != MobSpawnType.BUCKET && event.getSpawnType() != MobSpawnType.MOB_SUMMONED && event.getSpawnType() != MobSpawnType.COMMAND && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        if (SpawnProtectionEvents.ignore(Type.DAMAGE)) {
            return;
        }
        if (!(event.getSource().m_269533_(DamageTypeTags.f_268738_) || !SpawnProtectionEvents.isOnSpawn((Entity)event.getEntity()) || event.getSource().m_7639_() instanceof Player && event.getSource().m_7639_().m_20310_(2))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent event) {
        if (SpawnProtectionEvents.ignore(Type.DAMAGE)) {
            return;
        }
        if (!(event.getSource().m_269533_(DamageTypeTags.f_268738_) || !SpawnProtectionEvents.isOnSpawn((Entity)event.getEntity()) || !(event.getEntity() instanceof Player) && event.getSource().m_7639_() instanceof Player && event.getSource().m_7639_().m_20310_(2))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent event) {
        if (SpawnProtectionEvents.ignore(Type.DAMAGE) || SpawnProtectionEvents.ignore(Type.INTERACT_ENTITIES)) {
            return;
        }
        if (SpawnProtectionEvents.isOnSpawn(event.getTarget()) && !event.getEntity().m_20310_(2)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (SpawnProtectionEvents.ignore(Type.HEALING)) {
            return;
        }
        if (!event.player.m_9236_().f_46443_ && !event.player.m_21224_() && event.player.f_19797_ % 20 == 0 && SpawnProtectionEvents.isOnSpawn((Entity)event.player)) {
            event.player.m_21153_(event.player.m_21233_());
            event.player.m_36324_().m_38705_(20);
            event.player.m_20301_(event.player.m_6062_());
            event.player.m_7311_(0);
        }
    }

    private static boolean ignore(Type type) {
        return !SpawnConfig.spawnProtectionEvents.contains((Object)type);
    }

    private static boolean isOnSpawn(Entity entity) {
        return SpawnProtectionEvents.isOnSpawn(entity.m_9236_(), entity.m_20183_());
    }

    private static boolean isOnSpawn(Level level, BlockPos blockPos) {
        ChunkPos pos = new ChunkPos(blockPos);
        return WorldUtil.isSkyblock(level) && SpawnConfig.dimension == level.m_46472_() && Math.abs(pos.f_45578_) < SpawnConfig.spawnProtectionRadius && Math.abs(pos.f_45579_) < SpawnConfig.spawnProtectionRadius && !level.m_151570_(blockPos);
    }

    public static enum Type {
        INTERACT_ENTITIES,
        INTERACT_BLOCKS,
        MOB_GRIEFING,
        EXPLOSIONS,
        CROP_GROW,
        APPLY_BONEMEAL,
        MOBS_SPAWN,
        MOBS_SPAWN_EGG,
        DAMAGE,
        HEALING;

    }
}

