/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.api.SkyblockBuilderAPI;
import de.melanx.skyblockbuilder.client.GameProfileCache;
import de.melanx.skyblockbuilder.commands.CreateCommand;
import de.melanx.skyblockbuilder.commands.HomeCommand;
import de.melanx.skyblockbuilder.commands.LeaveCommand;
import de.melanx.skyblockbuilder.commands.SpawnCommand;
import de.melanx.skyblockbuilder.commands.TeamCommand;
import de.melanx.skyblockbuilder.commands.VisitCommand;
import de.melanx.skyblockbuilder.commands.helper.ConvertCommand;
import de.melanx.skyblockbuilder.commands.helper.InventoryCommand;
import de.melanx.skyblockbuilder.commands.helper.ListCommand;
import de.melanx.skyblockbuilder.commands.helper.LocateCommand;
import de.melanx.skyblockbuilder.commands.helper.SpawnsCommand;
import de.melanx.skyblockbuilder.commands.helper.TemplatesToSnbtCommand;
import de.melanx.skyblockbuilder.commands.invitation.AcceptCommand;
import de.melanx.skyblockbuilder.commands.invitation.DeclineCommand;
import de.melanx.skyblockbuilder.commands.invitation.InviteCommand;
import de.melanx.skyblockbuilder.commands.invitation.JoinCommand;
import de.melanx.skyblockbuilder.commands.operator.GenerateCommand;
import de.melanx.skyblockbuilder.commands.operator.ManageCommand;
import de.melanx.skyblockbuilder.compat.CadmusCompat;
import de.melanx.skyblockbuilder.config.StartingInventory;
import de.melanx.skyblockbuilder.config.common.CustomizationConfig;
import de.melanx.skyblockbuilder.config.common.InventoryConfig;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.data.TemplateData;
import de.melanx.skyblockbuilder.item.ItemStructureSaver;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.moddingx.libx.event.ConfigLoadedEvent;
import org.moddingx.libx.render.RenderHelperLevel;

@Mod.EventBusSubscriber(modid="skyblockbuilder")
public class EventListener {
    private static final String SPAWNED_TAG = "alreadySpawned";

    @SubscribeEvent
    public static void resourcesReload(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            return;
        }
        SkyPaths.generateDefaultFiles(event.getPlayerList().m_7873_());
        TemplateLoader.updateTemplates();
        SkyblockBuilder.getNetwork().updateTemplateNames(TemplateLoader.getTemplateNames());
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(LocateCommand.register());
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skyblock").requires(source -> SkyblockBuilderAPI.teamManagementEnabled())).then(AcceptCommand.register())).then(ConvertCommand.register())).then(CreateCommand.register())).then(DeclineCommand.register())).then(GenerateCommand.register())).then(HomeCommand.register())).then(InventoryCommand.register())).then(InviteCommand.register())).then(JoinCommand.register())).then(LeaveCommand.register())).then(ListCommand.register())).then(ManageCommand.register())).then(SpawnCommand.register())).then(SpawnsCommand.register())).then(TeamCommand.register())).then(TemplatesToSnbtCommand.register())).then(VisitCommand.register()));
        if (ModList.get().isLoaded("cadmus")) {
            event.getDispatcher().register(CadmusCompat.spawnProtectionCommand());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LightningBolt) {
            LightningBolt lightning = (LightningBolt)entity;
            if (WorldUtil.isSkyblock(event.getLevel())) {
                ServerLevel level = (ServerLevel)event.getLevel();
                BlockPos pos = new BlockPos((int)lightning.m_20182_().f_82479_, level.m_5736_(), (int)lightning.m_20182_().f_82481_);
                Optional rodPos = level.m_143248_(pos);
                rodPos.ifPresent(blockPos -> lightning.m_20219_(Vec3.m_82539_((Vec3i)blockPos)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        SkyblockBuilder.getNetwork().updateData(event.getEntity(), null);
        Level level = event.getEntity().m_9236_();
        SkyblockBuilder.getNetwork().updateProfiles(level);
        SkyblockBuilder.getNetwork().updateTemplateNames(event.getEntity(), TemplateLoader.getTemplateNames());
        if (level instanceof ServerLevel && WorldUtil.isSkyblock(level) && SkyblockBuilderAPI.isSpawnTeleportEnabled()) {
            SkyblockSavedData data = SkyblockSavedData.get(level);
            ServerPlayer player = (ServerPlayer)event.getEntity();
            Team spawn = data.getSpawn();
            GameProfileCache.addProfiles(Set.of(player.m_36316_()));
            if (player.getPersistentData().m_128471_(SPAWNED_TAG)) {
                if (!data.hasPlayerTeam((Player)player) && !spawn.hasPlayer((Player)player)) {
                    if (InventoryConfig.dropItems) {
                        RandomUtility.dropInventories((Player)player);
                    }
                    WorldUtil.teleportToIsland(player, spawn);
                    data.addPlayerToTeam(SkyblockSavedData.SPAWN_ID, (Player)player);
                    SkyblockBuilder.getLogger().info("Put {} back into spawn team.", (Object)player.m_5446_());
                }
                return;
            }
            player.getPersistentData().m_128379_(SPAWNED_TAG, true);
            data.getOrCreateMetaInfo((Player)player);
            if (InventoryConfig.clearInv) {
                player.m_150109_().m_6211_();
            }
            SkyblockBuilder.getLogger().info("First time {} joined. Putting into spawn team.", (Object)player.m_5446_());
            data.addPlayerToTeam(spawn, (Player)player);
            try {
                WorldUtil.Directions direction = !spawn.getDefaultPossibleSpawns().isEmpty() ? ((TemplatesConfig.Spawn)spawn.getDefaultPossibleSpawns().stream().findFirst().get()).direction() : ((TemplatesConfig.Spawn)spawn.getPossibleSpawns().stream().findFirst().get()).direction();
                ((ServerLevel)level).m_8733_(spawn.getIsland().getCenter(), (float)direction.getYRot());
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("No possible spawn point set for spawn", e);
            }
            WorldUtil.teleportToIsland(player, spawn);
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        Player newPlayer = event.getEntity();
        CompoundTag newData = newPlayer.getPersistentData();
        Player oldPlayer = event.getOriginal();
        CompoundTag oldData = oldPlayer.getPersistentData();
        newData.m_128379_(SPAWNED_TAG, oldData.m_128471_(SPAWNED_TAG));
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            BlockPos pos = player.m_8961_();
            ServerLevel level = (ServerLevel)player.m_9236_();
            if (!WorldUtil.isSkyblock((Level)level)) {
                return;
            }
            if (pos == null || !level.m_8055_(pos).m_204336_(BlockTags.f_13038_) && !level.m_8055_(pos).m_60713_(Blocks.f_50724_)) {
                SkyblockSavedData data = SkyblockSavedData.get((Level)level);
                Team team = data.getTeamFromPlayer((Player)player);
                WorldUtil.teleportToIsland(player, team == null ? data.getSpawn() : team);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        SkyPaths.generateDefaultFiles(server);
        if (WorldUtil.isSkyblock((Level)server.m_129783_())) {
            SkyblockBuilder.getLogger().info("Successfully loaded Skyblock!");
            TemplateLoader.updateTemplates();
            SkyblockBuilder.getNetwork().updateTemplateNames(TemplateLoader.getTemplateNames());
            TemplateData.get(server.m_129783_());
            Set<GameProfile> profiles = RandomUtility.getGameProfiles(server.m_129783_());
            GameProfileCache.addProfiles(profiles);
            if (SkyblockBuilderAPI.isSpawnTeleportEnabled()) {
                SkyblockSavedData.get((Level)server.m_129783_()).getSpawn();
            }
        }
    }

    @SubscribeEvent
    public static void onTabListName(PlayerEvent.TabListNameFormat event) {
        if (!CustomizationConfig.showTeamInTabList) {
            return;
        }
        Player player = event.getEntity();
        Team team = SkyblockSavedData.get(player.m_9236_()).getTeamFromPlayer(player);
        if (team != null) {
            MutableComponent name = (MutableComponent)player.m_5446_();
            Style style = name.m_7383_();
            if (style.m_131135_() == null) {
                style.m_131140_(ChatFormatting.WHITE);
            }
            MutableComponent teamName = Component.m_237113_((String)team.getName()).m_130940_(ChatFormatting.AQUA);
            event.setDisplayName((Component)Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"[").m_130948_(style)).m_7220_((Component)teamName.m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"] ").m_130948_(style)).m_7220_((Component)name.m_130948_(style)));
        } else {
            event.setDisplayName(null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderBoundingBox(RenderLevelStageEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !(player.m_21205_().m_41720_() instanceof ItemStructureSaver) || event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        ItemStack stack = player.m_21205_();
        BoundingBox area = ItemStructureSaver.getArea(stack);
        if (area == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        RenderHelperLevel.loadCameraPosition((Camera)event.getCamera(), (PoseStack)poseStack, (double)area.m_162395_(), (double)area.m_162396_(), (double)area.m_162398_());
        MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer buffer = source.m_6299_((RenderType)RenderType.f_110371_);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)buffer, (double)0.0, (double)0.0, (double)0.0, (double)(area.m_162399_() - area.m_162395_() + 1), (double)(area.m_162400_() - area.m_162396_() + 1), (double)(area.m_162401_() - area.m_162398_() + 1), (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        source.m_109912_((RenderType)RenderType.f_110371_);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigLoadedEvent event) {
        if (event.getConfigClass() == TemplatesConfig.class) {
            StartingInventory.loadStarterItems();
            if (event.getReason() != ConfigLoadedEvent.LoadReason.SHADOW) {
                TemplateLoader.updateTemplates();
            }
            if (PermissionsConfig.forceSkyblockCheck) {
                SkyblockBuilder.getLogger().warn("'forceSkyblockCheck' is enabled, no support for failures");
            }
        }
    }
}

