/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.utils.forge.VibeCheckerImpl;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class VibeChecker {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void checkVibe() {
        VibeCheckerImpl.checkVibe();
    }

    public static void checkVibe(Level level) {
        VibeChecker.checkDatapackRegistry();
        if (PlatHelper.getPhysicalSide().isClient()) {
            VibeChecker.clientStuff();
        }
    }

    public static void checkDatapackRegistry() {
        try {
            SoftFluidRegistry.getEmpty();
        }
        catch (Exception e) {
            throw new RuntimeException("Not all required entries were found in datapack registry. How did this happen?Note that this could be caused by Paper or similar servers. Know that those are NOT meant to be used with mods", e);
        }
    }

    private static void clientStuff() {
        for (ResourceKey v : BuiltInRegistries.f_256878_.m_214010_()) {
            if (Sheets.f_173376_.containsKey(v)) continue;
            ArrayList keys = new ArrayList(BuiltInRegistries.f_256878_.m_214010_());
            keys.removeAll(Sheets.f_173376_.keySet());
            throw new BadModError("Some OTHER mod loaded the Sheets class to early, causing modded banner patterns and sherds textures to not include modded ones.\nRefusing to proceed further. Do Not report this to Supplementaries\nMissing entries: " + keys + "\nCheck previous forge log lines to find the offending mod (if its a forge mod). Good luck if a connector mod caused this tho.");
        }
        for (ResourceKey v : BuiltInRegistries.f_271353_.m_214010_()) {
            if (Sheets.f_271486_.containsKey(v)) continue;
            ArrayList keys = new ArrayList(BuiltInRegistries.f_271353_.m_214010_());
            keys.removeAll(Sheets.f_271486_.keySet());
            throw new BadModError("Some OTHER mod loaded the Sheets class to early, causing modded banner patterns and sherds textures to not include modded ones.\nRefusing to proceed further. Do Not report this to Supplementaries\nMissing entries: " + keys + "\nCheck previous forge log lines to find the offending mod (if its a forge mod). Good luck if a connector mod caused this tho.");
        }
    }

    private static void crashWhenStolenMod() {
        String s = "creaturesfromthesnow";
        if (PlatHelper.isModLoaded((String)s)) {
            Supplementaries.LOGGER.error("[!!!] The mod " + s + " contains stolen assets and code from Frozen Up which is ARR.");
        }
    }

    public static class BadModError
    extends Error {
        public BadModError(String s) {
            super(s);
        }

        public BadModError(String s, Exception e) {
            super(s, e);
        }
    }
}

