/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeKnotBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RopeKnotBlockTile
extends MimicBlockTile {
    private VoxelShape collisionShape = null;
    private VoxelShape shape = null;
    private static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public RopeKnotBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.ROPE_KNOT_TILE.get(), pos, state);
        this.setHeldBlock(Blocks.f_50016_.m_49966_());
    }

    public VoxelShape getCollisionShape() {
        if (this.collisionShape == null) {
            this.recalculateShapes(this.m_58900_());
        }
        return Objects.requireNonNullElseGet(this.collisionShape, Shapes::m_83144_);
    }

    public VoxelShape getShape() {
        if (this.shape == null) {
            this.recalculateShapes(this.m_58900_());
        }
        return Objects.requireNonNullElseGet(this.shape, Shapes::m_83144_);
    }

    public void recalculateShapes(BlockState state) {
        try {
            VoxelShape r;
            if (state == null || !state.m_60713_(ModRegistry.ROPE_KNOT.get()) || this.f_58857_ == null) {
                return;
            }
            BlockState mimic = this.getHeldBlock();
            if (mimic.m_60795_()) {
                mimic = Blocks.f_50069_.m_49966_();
            }
            boolean up = (Boolean)state.m_61143_((Property)AbstractRopeKnotBlock.UP);
            boolean down = (Boolean)state.m_61143_((Property)AbstractRopeKnotBlock.DOWN);
            if (down && !up) {
                r = DOWN_SHAPE;
            } else {
                BlockState rope = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)ModRegistry.ROPE.get().m_49966_().m_61124_((Property)AbstractRopeBlock.KNOT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AbstractRopeKnotBlock.UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)AbstractRopeKnotBlock.DOWN, (Comparable)Boolean.valueOf(down))).m_61124_((Property)AbstractRopeKnotBlock.NORTH, (Comparable)((Boolean)state.m_61143_((Property)AbstractRopeKnotBlock.NORTH)))).m_61124_((Property)AbstractRopeKnotBlock.SOUTH, (Comparable)((Boolean)state.m_61143_((Property)AbstractRopeKnotBlock.SOUTH)))).m_61124_((Property)AbstractRopeKnotBlock.EAST, (Comparable)((Boolean)state.m_61143_((Property)AbstractRopeKnotBlock.EAST)))).m_61124_((Property)AbstractRopeKnotBlock.WEST, (Comparable)((Boolean)state.m_61143_((Property)AbstractRopeKnotBlock.WEST)));
                r = rope.m_60808_((BlockGetter)this.f_58857_, this.f_58858_);
            }
            VoxelShape c = mimic.m_60812_((BlockGetter)this.f_58857_, this.f_58858_);
            VoxelShape s = mimic.m_60808_((BlockGetter)this.f_58857_, this.f_58858_);
            c = Shapes.m_83110_((VoxelShape)c, (VoxelShape)r);
            s = Shapes.m_83110_((VoxelShape)s, (VoxelShape)r);
            this.collisionShape = c.m_83296_();
            this.shape = s.m_83296_();
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("failed to calculate roped fence hitbox: " + e);
        }
    }

    public void m_6596_() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.requestModelReload();
        this.collisionShape = null;
        this.shape = null;
        super.m_6596_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.collisionShape = null;
        this.shape = null;
    }
}

