/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.funny;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.PicklePacket;
import net.mehvahdjukaar.supplementaries.common.utils.Credits;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PickleData {
    private static final UUID ME = UUID.fromString("898b3a39-e486-405c-a873-d6b472dc3ba2");
    protected static final Map<UUID, PickleValues> PICKLE_PLAYERS = new HashMap<UUID, PickleValues>();
    private static final PickleValues DEF;

    public static void onPlayerLogOff() {
        for (PickleValues val : PICKLE_PLAYERS.values()) {
            val.reset();
        }
    }

    public static void onPlayerLogin(Player player) {
        for (Map.Entry<UUID, PickleValues> e : PICKLE_PLAYERS.entrySet()) {
            boolean on = e.getValue().isOn();
            UUID id = e.getKey();
            if (!on) continue;
            ModNetwork.CHANNEL.sendToClientPlayer((ServerPlayer)player, (Message)new PicklePacket(id, on, e.getValue().isJar));
        }
    }

    public static boolean isDev(UUID id, boolean isJar) {
        return PICKLE_PLAYERS.containsKey(id);
    }

    public static void set(UUID id, boolean on, boolean isJar) {
        PICKLE_PLAYERS.getOrDefault(id, DEF).toggle(on, isJar);
    }

    public static boolean isActiveAndTick(UUID id, PlayerRenderer renderer) {
        return PICKLE_PLAYERS.getOrDefault(id, DEF).isOnAndTick(renderer);
    }

    public static boolean isActive(UUID id) {
        return PICKLE_PLAYERS.getOrDefault(id, DEF).isOn();
    }

    static {
        for (UUID id : Credits.INSTANCE.getDevs()) {
            PickleValues value = new PickleValues();
            PICKLE_PLAYERS.put(id, value);
            if (!ME.equals(id)) continue;
            value.toggle(true, true);
        }
        DEF = new PickleValues();
    }

    public static class PickleValues {
        private State state = State.OFF;
        private boolean isJar = false;
        private float oldShadowSize = 1.0f;

        public void toggle(boolean on, boolean isJar) {
            this.isJar = isJar;
            this.state = on ? State.FIRST_ON : State.FIRST_OFF;
        }

        public void reset() {
            this.state = State.OFF;
        }

        public boolean isOnAndTick(PlayerRenderer renderer) {
            switch (this.state) {
                case ON: {
                    if (this.isJar) {
                        ((PlayerModel)renderer.m_7200_()).f_102808_.f_104207_ = false;
                        ((PlayerModel)renderer.m_7200_()).f_102809_.f_104207_ = false;
                        return false;
                    }
                    return true;
                }
                default: {
                    return false;
                }
                case FIRST_ON: {
                    this.oldShadowSize = renderer.f_114477_;
                    this.state = State.ON;
                    if (this.isJar) {
                        ((PlayerModel)renderer.m_7200_()).f_102808_.f_104207_ = false;
                        ((PlayerModel)renderer.m_7200_()).f_102809_.f_104207_ = false;
                        return false;
                    }
                    renderer.f_114477_ = 0.0f;
                    return true;
                }
                case FIRST_OFF: 
            }
            renderer.f_114477_ = this.oldShadowSize;
            ((PlayerModel)renderer.m_7200_()).f_102808_.f_104207_ = true;
            ((PlayerModel)renderer.m_7200_()).f_102809_.f_104207_ = true;
            this.state = State.OFF;
            return true;
        }

        public boolean isOn() {
            return this.state == State.ON || this.state == State.FIRST_ON;
        }

        private static enum State {
            ON,
            OFF,
            FIRST_ON,
            FIRST_OFF;

        }
    }
}

