/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.theducksmod.mobs.fox;

import com.google.common.collect.Lists;
import com.minecraftserverzone.theducksmod.mobs.Duck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.StrollThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class NewFox
extends Animal {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(NewFox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(NewFox.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final int FLAG_CROUCHING = 4;
    public static final int FLAG_INTERESTED = 8;
    public static final int FLAG_POUNCING = 16;
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_0 = SynchedEntityData.m_135353_(NewFox.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_1 = SynchedEntityData.m_135353_(NewFox.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    static final Predicate<ItemEntity> ALLOWED_ITEMS = p_28528_ -> !p_28528_.m_32063_() && p_28528_.m_6084_();
    private static final Predicate<Entity> TRUSTED_TARGET_SELECTOR = p_28521_ -> {
        if (!(p_28521_ instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)p_28521_;
        return livingentity.m_21214_() != null && livingentity.m_21215_() < livingentity.f_19797_ + 600;
    };
    static final Predicate<Entity> STALKABLE_PREY = p_28498_ -> p_28498_ instanceof Chicken || p_28498_ instanceof Duck || p_28498_ instanceof Rabbit;
    private static final Predicate<Entity> AVOID_PLAYERS = p_28463_ -> !p_28463_.m_20163_() && EntitySelector.f_20406_.test(p_28463_);
    private Goal landTargetGoal;
    private Goal turtleEggTargetGoal;
    private Goal fishTargetGoal;
    private float interestedAngle;
    private float interestedAngleO;
    float crouchAmount;
    float crouchAmountO;
    private int ticksSinceEaten;

    public NewFox(EntityType<? extends NewFox> p_28451_, Level p_28452_) {
        super(p_28451_, p_28452_);
        this.f_21365_ = new FoxLookControl();
        this.f_21342_ = new FoxMoveControl();
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
        this.m_21553_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_0, Optional.empty());
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_1, Optional.empty());
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected void m_8099_() {
        this.landTargetGoal = new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, false, false, p_28604_ -> p_28604_ instanceof Chicken || p_28604_ instanceof Duck || p_28604_ instanceof Rabbit);
        this.turtleEggTargetGoal = new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, false, false, Turtle.f_30122_);
        this.fishTargetGoal = new NearestAttackableTargetGoal((Mob)this, AbstractFish.class, 20, false, false, p_28600_ -> p_28600_ instanceof AbstractSchoolingFish);
        this.f_21345_.m_25352_(0, (Goal)new FoxFloatGoal());
        this.f_21345_.m_25352_(1, (Goal)new FaceplantGoal());
        this.f_21345_.m_25352_(2, (Goal)new FoxPanicGoal(2.2));
        this.f_21345_.m_25352_(3, (Goal)new FoxBreedGoal(1.0));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 1.6, 1.4, p_28596_ -> AVOID_PLAYERS.test((Entity)p_28596_) && !this.trusts(p_28596_.m_20148_()) && !this.isDefending()));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 8.0f, 1.6, 1.4, p_28590_ -> !((Wolf)p_28590_).m_21824_() && !this.isDefending()));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 8.0f, 1.6, 1.4, p_28585_ -> !this.isDefending()));
        this.f_21345_.m_25352_(5, (Goal)new StalkPreyGoal());
        this.f_21345_.m_25352_(6, (Goal)new FoxPounceGoal());
        this.f_21345_.m_25352_(6, (Goal)new SeekShelterGoal(1.25));
        this.f_21345_.m_25352_(7, (Goal)new FoxMeleeAttackGoal(1.2f, true));
        this.f_21345_.m_25352_(7, (Goal)new SleepGoal());
        this.f_21345_.m_25352_(8, (Goal)new FoxFollowParentGoal(this, 1.25));
        this.f_21345_.m_25352_(9, (Goal)new FoxStrollThroughVillageGoal(32, 200));
        this.f_21345_.m_25352_(10, (Goal)new FoxEatBerriesGoal(1.2f, 12, 1));
        this.f_21345_.m_25352_(10, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(11, (Goal)new FoxSearchForItemsGoal());
        this.f_21345_.m_25352_(12, (Goal)new FoxLookAtPlayerGoal((Mob)this, Player.class, 24.0f));
        this.f_21345_.m_25352_(13, (Goal)new PerchAndSearchGoal());
        this.f_21346_.m_25352_(3, (Goal)new DefendTrustedTargetGoal(LivingEntity.class, false, false, p_28580_ -> TRUSTED_TARGET_SELECTOR.test((Entity)p_28580_) && !this.trusts(p_28580_.m_20148_())));
    }

    public SoundEvent m_7866_(ItemStack p_28540_) {
        return SoundEvents.f_11947_;
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_()) {
            LivingEntity livingentity;
            ++this.ticksSinceEaten;
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEat(itemstack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack itemstack1 = itemstack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    if (!itemstack1.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.f_19796_.m_188501_() < 0.1f) {
                    this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                }
            }
            if ((livingentity = this.m_5448_()) == null || !livingentity.m_6084_()) {
                this.setIsCrouching(false);
                this.setIsInterested(false);
            }
        }
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        super.m_8107_();
        if (this.isDefending() && this.f_19796_.m_188501_() < 0.05f) {
            this.m_5496_(SoundEvents.f_11943_, 1.0f, 1.0f);
        }
    }

    protected boolean m_6107_() {
        return this.m_21224_();
    }

    private boolean canEat(ItemStack p_28598_) {
        return p_28598_.m_41720_().m_41472_() && this.m_5448_() == null && this.m_20096_() && !this.m_5803_();
    }

    protected void populateDefaultEquipmentSlots(DifficultyInstance p_28461_) {
        if (this.f_19796_.m_188501_() < 0.2f) {
            float f = this.f_19796_.m_188501_();
            ItemStack itemstack = f < 0.05f ? new ItemStack((ItemLike)Items.f_42616_) : (f < 0.2f ? new ItemStack((ItemLike)Items.f_42521_) : (f < 0.4f ? (this.f_19796_.m_188499_() ? new ItemStack((ItemLike)Items.f_42648_) : new ItemStack((ItemLike)Items.f_42649_)) : (f < 0.6f ? new ItemStack((ItemLike)Items.f_42405_) : (f < 0.8f ? new ItemStack((ItemLike)Items.f_42454_) : new ItemStack((ItemLike)Items.f_42402_)))));
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public void m_7822_(byte p_28456_) {
        if (p_28456_ == 45) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
                }
            }
        } else {
            super.m_7822_(p_28456_);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public NewFox getBreedOffspring(ServerLevel p_148912_, AgeableMob p_148913_) {
        NewFox fox = (NewFox)this.m_6095_().m_20615_((Level)p_148912_);
        fox.setFoxType(this.f_19796_.m_188499_() ? this.getFoxType() : ((NewFox)p_148913_).getFoxType());
        return fox;
    }

    public static boolean checkFoxSpawnRules(EntityType<NewFox> p_186214_, ServerLevelAccessor p_186215_, MobSpawnType p_186216_, BlockPos p_186217_, RandomSource p_186218_) {
        return p_186215_.m_8055_(p_186217_.m_7495_()).m_204336_(BlockTags.f_184235_) && NewFox.m_186209_((BlockAndTintGetter)p_186215_, (BlockPos)p_186217_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_28487_, DifficultyInstance p_28488_, MobSpawnType p_28489_, @Nullable SpawnGroupData p_28490_, @Nullable CompoundTag p_28491_) {
        Holder holder = p_28487_.m_204166_(this.m_20183_());
        Type fox$type = Type.byBiome((Holder<Biome>)holder);
        boolean flag = false;
        if (p_28490_ instanceof FoxGroupData) {
            fox$type = ((FoxGroupData)((Object)p_28490_)).type;
            if (((FoxGroupData)((Object)p_28490_)).m_146777_() >= 2) {
                flag = true;
            }
        } else {
            p_28490_ = new FoxGroupData(fox$type);
        }
        this.setFoxType(fox$type);
        if (flag) {
            this.m_146762_(-24000);
        }
        if (p_28487_ instanceof ServerLevel) {
            this.setTargetGoals();
        }
        this.populateDefaultEquipmentSlots(p_28488_);
        return super.m_6518_(p_28487_, p_28488_, p_28489_, p_28490_, p_28491_);
    }

    private void setTargetGoals() {
        if (this.getFoxType() == Type.RED) {
            this.f_21346_.m_25352_(4, this.landTargetGoal);
            this.f_21346_.m_25352_(4, this.turtleEggTargetGoal);
            this.f_21346_.m_25352_(6, this.fishTargetGoal);
        } else {
            this.f_21346_.m_25352_(4, this.fishTargetGoal);
            this.f_21346_.m_25352_(6, this.landTargetGoal);
            this.f_21346_.m_25352_(6, this.turtleEggTargetGoal);
        }
    }

    protected void m_142075_(Player p_148908_, InteractionHand p_148909_, ItemStack p_148910_) {
        if (this.m_6898_(p_148910_)) {
            this.m_5496_(this.m_7866_(p_148910_), 1.0f, 1.0f);
        }
        super.m_142075_(p_148908_, p_148909_, p_148910_);
    }

    protected float m_6431_(Pose p_28500_, EntityDimensions p_28501_) {
        return this.m_6162_() ? p_28501_.f_20378_ * 0.85f : 0.4f;
    }

    public Type getFoxType() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_TYPE_ID));
    }

    private void setFoxType(Type p_28465_) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)p_28465_.getId());
    }

    List<UUID> getTrustedUUIDs() {
        ArrayList list = Lists.newArrayList();
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).orElse(null));
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_1)).orElse(null));
        return list;
    }

    void addTrustedUUID(@Nullable UUID p_28516_) {
        if (((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).isPresent()) {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_1, Optional.ofNullable(p_28516_));
        } else {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_0, Optional.ofNullable(p_28516_));
        }
    }

    public void m_7380_(CompoundTag p_28518_) {
        super.m_7380_(p_28518_);
        List<UUID> list = this.getTrustedUUIDs();
        ListTag listtag = new ListTag();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listtag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        p_28518_.m_128365_("Trusted", (Tag)listtag);
        p_28518_.m_128379_("Sleeping", this.m_5803_());
        p_28518_.m_128359_("Type", this.getFoxType().getName());
        p_28518_.m_128379_("Sitting", this.isSitting());
        p_28518_.m_128379_("Crouching", this.m_6047_());
    }

    public void m_7378_(CompoundTag p_28493_) {
        super.m_7378_(p_28493_);
        ListTag listtag = p_28493_.m_128437_("Trusted", 11);
        for (int i = 0; i < listtag.size(); ++i) {
            this.addTrustedUUID(NbtUtils.m_129233_((Tag)listtag.get(i)));
        }
        this.setSleeping(p_28493_.m_128471_("Sleeping"));
        this.setFoxType(Type.byName(p_28493_.m_128461_("Type")));
        this.setSitting(p_28493_.m_128471_("Sitting"));
        this.setIsCrouching(p_28493_.m_128471_("Crouching"));
        if (this.m_9236_() instanceof ServerLevel) {
            this.setTargetGoals();
        }
    }

    public boolean isSitting() {
        return this.getFlag(1);
    }

    public void setSitting(boolean p_28611_) {
        this.setFlag(1, p_28611_);
    }

    public boolean isFaceplanted() {
        return this.getFlag(64);
    }

    void setFaceplanted(boolean p_28619_) {
        this.setFlag(64, p_28619_);
    }

    boolean isDefending() {
        return this.getFlag(128);
    }

    void setDefending(boolean p_28623_) {
        this.setFlag(128, p_28623_);
    }

    public boolean m_5803_() {
        return this.getFlag(32);
    }

    void setSleeping(boolean p_28627_) {
        this.setFlag(32, p_28627_);
    }

    private void setFlag(int p_28533_, boolean p_28534_) {
        if (p_28534_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | p_28533_)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~p_28533_)));
        }
    }

    private boolean getFlag(int p_28609_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & p_28609_) != 0;
    }

    public boolean m_7066_(ItemStack p_28552_) {
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)p_28552_);
        if (!this.m_6844_(equipmentslot).m_41619_()) {
            return false;
        }
        return equipmentslot == EquipmentSlot.MAINHAND && super.m_7066_(p_28552_);
    }

    public boolean m_7252_(ItemStack p_28578_) {
        Item item = p_28578_.m_41720_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() || this.ticksSinceEaten > 0 && item.m_41472_() && !itemstack.m_41720_().m_41472_();
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, p_28602_);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_20148_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack p_28606_) {
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), p_28606_);
        this.m_9236_().m_7967_((Entity)itementity);
    }

    protected void m_7581_(ItemEntity p_28514_) {
        ItemStack itemstack = p_28514_.m_32055_();
        if (this.m_7252_(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.dropItemStack(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(p_28514_);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)p_28514_, itemstack.m_41613_());
            p_28514_.m_146870_();
            this.ticksSinceEaten = 0;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21515_()) {
            boolean flag = this.m_20069_();
            if (flag || this.m_5448_() != null || this.m_9236_().m_46470_()) {
                this.wakeUp();
            }
            if (flag || this.m_5803_()) {
                this.setSitting(false);
            }
            if (this.isFaceplanted() && this.m_9236_().f_46441_.m_188501_() < 0.2f) {
                BlockPos blockpos = this.m_20183_();
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                this.m_9236_().m_46796_(2001, blockpos, Block.m_49956_((BlockState)blockstate));
            }
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        this.crouchAmountO = this.crouchAmount;
        if (this.m_6047_()) {
            this.crouchAmount += 0.2f;
            if (this.crouchAmount > 3.0f) {
                this.crouchAmount = 3.0f;
            }
        } else {
            this.crouchAmount = 0.0f;
        }
    }

    public boolean m_6898_(ItemStack p_28594_) {
        return p_28594_.m_204117_(ItemTags.f_144311_);
    }

    protected void m_5502_(Player p_28481_, Mob p_28482_) {
        ((NewFox)p_28482_).addTrustedUUID(p_28481_.m_20148_());
    }

    public boolean isPouncing() {
        return this.getFlag(16);
    }

    public void setIsPouncing(boolean p_28613_) {
        this.setFlag(16, p_28613_);
    }

    public boolean isJumping() {
        return this.f_20899_;
    }

    public boolean isFullyCrouched() {
        return this.crouchAmount == 3.0f;
    }

    public void setIsCrouching(boolean p_28615_) {
        this.setFlag(4, p_28615_);
    }

    public boolean m_6047_() {
        return this.getFlag(4);
    }

    public void setIsInterested(boolean p_28617_) {
        this.setFlag(8, p_28617_);
    }

    public boolean isInterested() {
        return this.getFlag(8);
    }

    public float getHeadRollAngle(float p_28621_) {
        return Mth.m_14179_((float)p_28621_, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.11f * (float)Math.PI;
    }

    public float getCrouchAmount(float p_28625_) {
        return Mth.m_14179_((float)p_28625_, (float)this.crouchAmountO, (float)this.crouchAmount);
    }

    public void m_6710_(@Nullable LivingEntity p_28574_) {
        if (this.isDefending() && p_28574_ == null) {
            this.setDefending(false);
        }
        super.m_6710_(p_28574_);
    }

    protected int m_5639_(float p_28545_, float p_28546_) {
        return Mth.m_14167_((float)((p_28545_ - 5.0f) * p_28546_));
    }

    void wakeUp() {
        this.setSleeping(false);
    }

    void clearStates() {
        this.setIsInterested(false);
        this.setIsCrouching(false);
        this.setSitting(false);
        this.setSleeping(false);
        this.setDefending(false);
        this.setFaceplanted(false);
    }

    boolean canMove() {
        return !this.m_5803_() && !this.isSitting() && !this.isFaceplanted();
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent == SoundEvents.f_11949_) {
            this.m_5496_(soundevent, 2.0f, this.m_6100_());
        } else {
            super.m_8032_();
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        List list;
        if (this.m_5803_()) {
            return SoundEvents.f_11950_;
        }
        if (!this.m_9236_().m_46461_() && this.f_19796_.m_188501_() < 0.1f && (list = this.m_9236_().m_6443_(Player.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0), EntitySelector.f_20408_)).isEmpty()) {
            return SoundEvents.f_11949_;
        }
        return SoundEvents.f_11944_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_28548_) {
        return SoundEvents.f_11948_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11946_;
    }

    boolean trusts(UUID p_28530_) {
        return this.getTrustedUUIDs().contains(p_28530_);
    }

    protected void m_6668_(DamageSource p_28536_) {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemstack.m_41619_()) {
            this.m_19983_(itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        super.m_6668_(p_28536_);
    }

    public static boolean isPathClear(NewFox p_28472_, LivingEntity p_28473_) {
        double d0 = p_28473_.m_20189_() - p_28472_.m_20189_();
        double d1 = p_28473_.m_20185_() - p_28472_.m_20185_();
        double d2 = d0 / d1;
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j / 6.0f) : d3 / d2;
            for (int k = 1; k < 4; ++k) {
                if (p_28472_.m_9236_().m_8055_(BlockPos.m_274561_((double)(p_28472_.m_20185_() + d4), (double)(p_28472_.m_20186_() + (double)k), (double)(p_28472_.m_20189_() + d3))).m_247087_()) continue;
                return false;
            }
        }
        return true;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.55f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public class FoxLookControl
    extends LookControl {
        public FoxLookControl() {
            super((Mob)NewFox.this);
        }

        public void m_8128_() {
            if (!NewFox.this.m_5803_()) {
                super.m_8128_();
            }
        }

        protected boolean m_8106_() {
            return !NewFox.this.isPouncing() && !NewFox.this.m_6047_() && !NewFox.this.isInterested() && !NewFox.this.isFaceplanted();
        }
    }

    class FoxMoveControl
    extends MoveControl {
        public FoxMoveControl() {
            super((Mob)NewFox.this);
        }

        public void m_8126_() {
            if (NewFox.this.canMove()) {
                super.m_8126_();
            }
        }
    }

    class FoxFloatGoal
    extends FloatGoal {
        public FoxFloatGoal() {
            super((Mob)NewFox.this);
        }

        public void m_8056_() {
            super.m_8056_();
            NewFox.this.clearStates();
        }

        public boolean m_8036_() {
            return NewFox.this.m_20069_() && NewFox.this.m_204036_(FluidTags.f_13131_) > 0.25 || NewFox.this.m_20077_();
        }
    }

    class FaceplantGoal
    extends Goal {
        int countdown;

        public FaceplantGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return NewFox.this.isFaceplanted();
        }

        public boolean m_8045_() {
            return this.m_8036_() && this.countdown > 0;
        }

        public void m_8056_() {
            this.countdown = this.m_183277_(40);
        }

        public void m_8041_() {
            NewFox.this.setFaceplanted(false);
        }

        public void m_8037_() {
            --this.countdown;
        }
    }

    class FoxPanicGoal
    extends PanicGoal {
        public FoxPanicGoal(double p_28734_) {
            super((PathfinderMob)NewFox.this, p_28734_);
        }

        public boolean m_8036_() {
            return !NewFox.this.isDefending() && super.m_8036_();
        }
    }

    class FoxBreedGoal
    extends BreedGoal {
        public FoxBreedGoal(double p_28668_) {
            super((Animal)NewFox.this, p_28668_);
        }

        public void m_8056_() {
            ((NewFox)this.f_25113_).clearStates();
            ((NewFox)this.f_25115_).clearStates();
            super.m_8056_();
        }

        protected void m_8026_() {
            ServerLevel serverlevel = (ServerLevel)this.f_25114_;
            NewFox fox = (NewFox)this.f_25113_.m_142606_(serverlevel, (AgeableMob)this.f_25115_);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this.f_25113_, (Mob)this.f_25115_, (AgeableMob)fox);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            fox = (NewFox)event.getChild();
            if (cancelled) {
                this.f_25113_.m_146762_(6000);
                this.f_25115_.m_146762_(6000);
                this.f_25113_.m_27594_();
                this.f_25115_.m_27594_();
                return;
            }
            if (fox != null) {
                ServerPlayer serverplayer = this.f_25113_.m_27592_();
                ServerPlayer serverplayer1 = this.f_25115_.m_27592_();
                ServerPlayer serverplayer2 = serverplayer;
                if (serverplayer != null) {
                    fox.addTrustedUUID(serverplayer.m_20148_());
                } else {
                    serverplayer2 = serverplayer1;
                }
                if (serverplayer1 != null && serverplayer != serverplayer1) {
                    fox.addTrustedUUID(serverplayer1.m_20148_());
                }
                if (serverplayer2 != null) {
                    serverplayer2.m_36220_(Stats.f_12937_);
                    CriteriaTriggers.f_10581_.m_147278_(serverplayer2, this.f_25113_, this.f_25115_, (AgeableMob)fox);
                }
                this.f_25113_.m_146762_(6000);
                this.f_25115_.m_146762_(6000);
                this.f_25113_.m_27594_();
                this.f_25115_.m_27594_();
                fox.m_146762_(-24000);
                fox.m_7678_(this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), 0.0f, 0.0f);
                serverlevel.m_47205_((Entity)fox);
                this.f_25114_.m_7605_((Entity)this.f_25113_, (byte)18);
                if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                    this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), this.f_25113_.m_217043_().m_188503_(7) + 1));
                }
            }
        }
    }

    class StalkPreyGoal
    extends Goal {
        public StalkPreyGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (NewFox.this.m_5803_()) {
                return false;
            }
            LivingEntity livingentity = NewFox.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && STALKABLE_PREY.test((Entity)livingentity) && NewFox.this.m_20280_((Entity)livingentity) > 36.0 && !NewFox.this.m_6047_() && !NewFox.this.isInterested() && !NewFox.this.f_20899_;
        }

        public void m_8056_() {
            NewFox.this.setSitting(false);
            NewFox.this.setFaceplanted(false);
        }

        public void m_8041_() {
            LivingEntity livingentity = NewFox.this.m_5448_();
            if (livingentity != null && NewFox.isPathClear(NewFox.this, livingentity)) {
                NewFox.this.setIsInterested(true);
                NewFox.this.setIsCrouching(true);
                NewFox.this.m_21573_().m_26573_();
                NewFox.this.m_21563_().m_24960_((Entity)livingentity, (float)NewFox.this.m_8085_(), (float)NewFox.this.m_8132_());
            } else {
                NewFox.this.setIsInterested(false);
                NewFox.this.setIsCrouching(false);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = NewFox.this.m_5448_();
            if (livingentity != null) {
                NewFox.this.m_21563_().m_24960_((Entity)livingentity, (float)NewFox.this.m_8085_(), (float)NewFox.this.m_8132_());
                if (NewFox.this.m_20280_((Entity)livingentity) <= 36.0) {
                    NewFox.this.setIsInterested(true);
                    NewFox.this.setIsCrouching(true);
                    NewFox.this.m_21573_().m_26573_();
                } else {
                    NewFox.this.m_21573_().m_5624_((Entity)livingentity, 1.5);
                }
            }
        }
    }

    public class FoxPounceGoal
    extends JumpGoal {
        public boolean m_8036_() {
            if (!NewFox.this.isFullyCrouched()) {
                return false;
            }
            LivingEntity livingentity = NewFox.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                if (livingentity.m_6374_() != livingentity.m_6350_()) {
                    return false;
                }
                boolean flag = NewFox.isPathClear(NewFox.this, livingentity);
                if (!flag) {
                    NewFox.this.m_21573_().m_6570_((Entity)livingentity, 0);
                    NewFox.this.setIsCrouching(false);
                    NewFox.this.setIsInterested(false);
                }
                return flag;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = NewFox.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                double d0 = NewFox.this.m_20184_().f_82480_;
                return !(d0 * d0 < (double)0.05f && Math.abs(NewFox.this.m_146909_()) < 15.0f && NewFox.this.m_20096_() || NewFox.this.isFaceplanted());
            }
            return false;
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            NewFox.this.m_6862_(true);
            NewFox.this.setIsPouncing(true);
            NewFox.this.setIsInterested(false);
            LivingEntity livingentity = NewFox.this.m_5448_();
            if (livingentity != null) {
                NewFox.this.m_21563_().m_24960_((Entity)livingentity, 60.0f, 30.0f);
                Vec3 vec3 = new Vec3(livingentity.m_20185_() - NewFox.this.m_20185_(), livingentity.m_20186_() - NewFox.this.m_20186_(), livingentity.m_20189_() - NewFox.this.m_20189_()).m_82541_();
                NewFox.this.m_20256_(NewFox.this.m_20184_().m_82520_(vec3.f_82479_ * 0.8, 0.9, vec3.f_82481_ * 0.8));
            }
            NewFox.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            NewFox.this.setIsCrouching(false);
            NewFox.this.crouchAmount = 0.0f;
            NewFox.this.crouchAmountO = 0.0f;
            NewFox.this.setIsInterested(false);
            NewFox.this.setIsPouncing(false);
        }

        public static float rotLerp(float p_14190_, float p_14191_, float p_14192_) {
            return p_14191_ + p_14190_ * FoxPounceGoal.wrapDegrees(p_14192_ - p_14191_);
        }

        public static float wrapDegrees(float p_14178_) {
            float f = p_14178_ % 360.0f;
            if (f >= 180.0f) {
                f -= 360.0f;
            }
            if (f < -180.0f) {
                f += 360.0f;
            }
            return f;
        }

        public void m_8037_() {
            LivingEntity livingentity = NewFox.this.m_5448_();
            if (livingentity != null) {
                NewFox.this.m_21563_().m_24960_((Entity)livingentity, 60.0f, 30.0f);
            }
            if (!NewFox.this.isFaceplanted()) {
                Vec3 vec3 = NewFox.this.m_20184_();
                if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && NewFox.this.m_146909_() != 0.0f) {
                    NewFox.this.m_146926_(Mth.m_14189_((float)NewFox.this.m_146909_(), (float)0.0f, (float)0.2f));
                } else {
                    double d0 = vec3.m_165924_();
                    double d1 = Math.signum(-vec3.f_82480_) * Math.acos(d0 / vec3.m_82553_()) * 57.2957763671875;
                    NewFox.this.m_146926_((float)d1);
                }
            }
            if (livingentity != null && NewFox.this.m_20270_((Entity)livingentity) <= 2.0f) {
                NewFox.this.m_7327_((Entity)livingentity);
            } else if (NewFox.this.m_146909_() > 0.0f && NewFox.this.m_20096_() && (float)NewFox.this.m_20184_().f_82480_ != 0.0f && NewFox.this.m_9236_().m_8055_(NewFox.this.m_20183_()).m_60713_(Blocks.f_50125_)) {
                NewFox.this.m_146926_(60.0f);
                NewFox.this.m_6710_(null);
                NewFox.this.setFaceplanted(true);
            }
        }
    }

    class SeekShelterGoal
    extends FleeSunGoal {
        private int interval;

        public SeekShelterGoal(double p_28777_) {
            super((PathfinderMob)NewFox.this, p_28777_);
            this.interval = SeekShelterGoal.m_186073_((int)100);
        }

        public boolean m_8036_() {
            if (!NewFox.this.m_5803_() && this.f_25214_.m_5448_() == null) {
                if (NewFox.this.m_9236_().m_46470_()) {
                    return true;
                }
                if (this.interval > 0) {
                    --this.interval;
                    return false;
                }
                this.interval = 100;
                BlockPos blockpos = this.f_25214_.m_20183_();
                return NewFox.this.m_9236_().m_46461_() && NewFox.this.m_9236_().m_45527_(blockpos) && !((ServerLevel)NewFox.this.m_9236_()).m_8802_(blockpos) && this.m_25226_();
            }
            return false;
        }

        public void m_8056_() {
            NewFox.this.clearStates();
            super.m_8056_();
        }
    }

    class FoxMeleeAttackGoal
    extends MeleeAttackGoal {
        public FoxMeleeAttackGoal(double p_28720_, boolean p_28721_) {
            super((PathfinderMob)NewFox.this, p_28720_, p_28721_);
        }

        protected void m_6739_(LivingEntity p_28724_, double p_28725_) {
            double d0 = this.m_6639_(p_28724_);
            if (p_28725_ <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)p_28724_);
                NewFox.this.m_5496_(SoundEvents.f_11945_, 1.0f, 1.0f);
            }
        }

        public void m_8056_() {
            NewFox.this.setIsInterested(false);
            super.m_8056_();
        }

        public boolean m_8036_() {
            return !NewFox.this.isSitting() && !NewFox.this.m_5803_() && !NewFox.this.m_6047_() && !NewFox.this.isFaceplanted() && super.m_8036_();
        }
    }

    class SleepGoal
    extends FoxBehaviorGoal {
        private static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.m_186073_((int)140);
        private int countdown;

        public SleepGoal() {
            this.countdown = NewFox.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (NewFox.this.f_20900_ == 0.0f && NewFox.this.f_20901_ == 0.0f && NewFox.this.f_20902_ == 0.0f) {
                return this.canSleep() || NewFox.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return NewFox.this.m_9236_().m_46461_() && this.hasShelter() && !this.alertable() && !NewFox.this.f_146808_;
        }

        public void m_8041_() {
            this.countdown = NewFox.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            NewFox.this.clearStates();
        }

        public void m_8056_() {
            NewFox.this.setSitting(false);
            NewFox.this.setIsCrouching(false);
            NewFox.this.setIsInterested(false);
            NewFox.this.m_6862_(false);
            NewFox.this.setSleeping(true);
            NewFox.this.m_21573_().m_26573_();
            NewFox.this.m_21566_().m_6849_(NewFox.this.m_20185_(), NewFox.this.m_20186_(), NewFox.this.m_20189_(), 0.0);
        }
    }

    class FoxFollowParentGoal
    extends FollowParentGoal {
        private final NewFox fox;

        public FoxFollowParentGoal(NewFox p_28696_, double p_28697_) {
            super((Animal)p_28696_, p_28697_);
            this.fox = p_28696_;
        }

        public boolean m_8036_() {
            return !this.fox.isDefending() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.fox.isDefending() && super.m_8045_();
        }

        public void m_8056_() {
            this.fox.clearStates();
            super.m_8056_();
        }
    }

    class FoxStrollThroughVillageGoal
    extends StrollThroughVillageGoal {
        public FoxStrollThroughVillageGoal(int p_28754_, int p_28755_) {
            super((PathfinderMob)NewFox.this, p_28755_);
        }

        public void m_8056_() {
            NewFox.this.clearStates();
            super.m_8056_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.canFoxMove();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.canFoxMove();
        }

        private boolean canFoxMove() {
            return !NewFox.this.m_5803_() && !NewFox.this.isSitting() && !NewFox.this.isDefending() && NewFox.this.m_5448_() == null;
        }
    }

    public class FoxEatBerriesGoal
    extends MoveToBlockGoal {
        protected int ticksWaited;

        public FoxEatBerriesGoal(double p_28675_, int p_28676_, int p_28677_) {
            super((PathfinderMob)NewFox.this, p_28675_, p_28676_, p_28677_);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader p_28680_, BlockPos p_28681_) {
            BlockState blockstate = p_28680_.m_8055_(p_28681_);
            return blockstate.m_60713_(Blocks.f_50685_) && (Integer)blockstate.m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 2 || CaveVines.m_152951_((BlockState)blockstate);
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.m_25625_() && NewFox.this.f_19796_.m_188501_() < 0.05f) {
                NewFox.this.m_5496_(SoundEvents.f_11951_, 1.0f, 1.0f);
            }
            super.m_8037_();
        }

        protected void onReachedTarget() {
            if (ForgeEventFactory.getMobGriefingEvent((Level)NewFox.this.m_9236_(), (Entity)NewFox.this)) {
                BlockState blockstate = NewFox.this.m_9236_().m_8055_(this.f_25602_);
                if (blockstate.m_60713_(Blocks.f_50685_)) {
                    this.pickSweetBerries(blockstate);
                } else if (CaveVines.m_152951_((BlockState)blockstate)) {
                    this.pickGlowBerry(blockstate);
                }
            }
        }

        private void pickGlowBerry(BlockState p_148927_) {
            CaveVines.m_269473_((Entity)NewFox.this, (BlockState)p_148927_, (Level)NewFox.this.m_9236_(), (BlockPos)this.f_25602_);
        }

        private void pickSweetBerries(BlockState p_148929_) {
            int i = (Integer)p_148929_.m_61143_((Property)SweetBerryBushBlock.f_57244_);
            p_148929_.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1));
            int j = 1 + NewFox.this.m_9236_().f_46441_.m_188503_(2) + (i == 3 ? 1 : 0);
            ItemStack itemstack = NewFox.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_()) {
                NewFox.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42780_));
                --j;
            }
            if (j > 0) {
                Block.m_49840_((Level)NewFox.this.m_9236_(), (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)Items.f_42780_, j));
            }
            NewFox.this.m_5496_(SoundEvents.f_12457_, 1.0f, 1.0f);
            NewFox.this.m_9236_().m_7731_(this.f_25602_, (BlockState)p_148929_.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 2);
        }

        public boolean m_8036_() {
            return !NewFox.this.m_5803_() && super.m_8036_();
        }

        public void m_8056_() {
            this.ticksWaited = 0;
            NewFox.this.setSitting(false);
            super.m_8056_();
        }
    }

    class FoxSearchForItemsGoal
    extends Goal {
        public FoxSearchForItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!NewFox.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (NewFox.this.m_5448_() == null && NewFox.this.m_21188_() == null) {
                if (!NewFox.this.canMove()) {
                    return false;
                }
                if (NewFox.this.m_217043_().m_188503_(FoxSearchForItemsGoal.m_186073_((int)10)) != 0) {
                    return false;
                }
                List list = NewFox.this.m_9236_().m_6443_(ItemEntity.class, NewFox.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
                return !list.isEmpty() && NewFox.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List list = NewFox.this.m_9236_().m_6443_(ItemEntity.class, NewFox.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemstack = NewFox.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                NewFox.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List list = NewFox.this.m_9236_().m_6443_(ItemEntity.class, NewFox.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                NewFox.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    class FoxLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public FoxLookAtPlayerGoal(Mob p_28707_, Class<? extends LivingEntity> p_28708_, float p_28709_) {
            super(p_28707_, p_28708_, p_28709_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !NewFox.this.isFaceplanted() && !NewFox.this.isInterested();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !NewFox.this.isFaceplanted() && !NewFox.this.isInterested();
        }
    }

    class PerchAndSearchGoal
    extends FoxBehaviorGoal {
        private double relX;
        private double relZ;
        private int lookTime;
        private int looksRemaining;

        public PerchAndSearchGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return NewFox.this.m_21188_() == null && NewFox.this.m_217043_().m_188501_() < 0.02f && !NewFox.this.m_5803_() && NewFox.this.m_5448_() == null && NewFox.this.m_21573_().m_26571_() && !this.alertable() && !NewFox.this.isPouncing() && !NewFox.this.m_6047_();
        }

        public boolean m_8045_() {
            return this.looksRemaining > 0;
        }

        public void m_8056_() {
            this.resetLook();
            this.looksRemaining = 2 + NewFox.this.m_217043_().m_188503_(3);
            NewFox.this.setSitting(true);
            NewFox.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            NewFox.this.setSitting(false);
        }

        public void m_8037_() {
            --this.lookTime;
            if (this.lookTime <= 0) {
                --this.looksRemaining;
                this.resetLook();
            }
            NewFox.this.m_21563_().m_24950_(NewFox.this.m_20185_() + this.relX, NewFox.this.m_20188_(), NewFox.this.m_20189_() + this.relZ, (float)NewFox.this.m_8085_(), (float)NewFox.this.m_8132_());
        }

        private void resetLook() {
            double d0 = Math.PI * 2 * NewFox.this.m_217043_().m_188500_();
            this.relX = Math.cos(d0);
            this.relZ = Math.sin(d0);
            this.lookTime = this.m_183277_(80 + NewFox.this.m_217043_().m_188503_(20));
        }
    }

    class DefendTrustedTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        @Nullable
        private LivingEntity trustedLastHurtBy;
        @Nullable
        private LivingEntity trustedLastHurt;
        private int timestamp;

        public DefendTrustedTargetGoal(Class<LivingEntity> p_28634_, @Nullable boolean p_28635_, boolean p_28636_, Predicate<LivingEntity> p_28637_) {
            super((Mob)NewFox.this, p_28634_, 10, p_28635_, p_28636_, p_28637_);
        }

        public boolean m_8036_() {
            if (this.f_26049_ > 0 && this.f_26135_.m_217043_().m_188503_(this.f_26049_) != 0) {
                return false;
            }
            for (UUID uuid : NewFox.this.getTrustedUUIDs()) {
                LivingEntity livingentity;
                Entity entity;
                if (uuid == null || !(NewFox.this.m_9236_() instanceof ServerLevel) || !((entity = ((ServerLevel)NewFox.this.m_9236_()).m_8791_(uuid)) instanceof LivingEntity)) continue;
                this.trustedLastHurt = livingentity = (LivingEntity)entity;
                this.trustedLastHurtBy = livingentity.m_21188_();
                int i = livingentity.m_21213_();
                return i != this.timestamp && this.m_26150_(this.trustedLastHurtBy, this.f_26051_);
            }
            return false;
        }

        public void m_8056_() {
            this.m_26070_(this.trustedLastHurtBy);
            this.f_26050_ = this.trustedLastHurtBy;
            if (this.trustedLastHurt != null) {
                this.timestamp = this.trustedLastHurt.m_21213_();
            }
            NewFox.this.m_5496_(SoundEvents.f_11943_, 1.0f, 1.0f);
            NewFox.this.setDefending(true);
            NewFox.this.wakeUp();
            super.m_8056_();
        }
    }

    public static enum Type {
        RED(0, "red"),
        SNOW(1, "snow");

        private static final Type[] BY_ID;
        private static final Map<String, Type> BY_NAME;
        private final int id;
        private final String name;

        private Type(int p_196658_, String p_196659_) {
            this.id = p_196658_;
            this.name = p_196659_;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Type byName(String p_28817_) {
            return BY_NAME.getOrDefault(p_28817_, RED);
        }

        public static Type byId(int p_28813_) {
            if (p_28813_ < 0 || p_28813_ > BY_ID.length) {
                p_28813_ = 0;
            }
            return BY_ID[p_28813_];
        }

        public static Type byBiome(Holder<Biome> p_204063_) {
            return p_204063_.m_203656_(BiomeTags.f_263748_) ? SNOW : RED;
        }

        static {
            BY_ID = (Type[])Arrays.stream(Type.values()).sorted(Comparator.comparingInt(Type::getId)).toArray(Type[]::new);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, p_28815_ -> p_28815_));
        }
    }

    public static class FoxGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Type type;

        public FoxGroupData(Type p_28703_) {
            super(false);
            this.type = p_28703_;
        }
    }

    abstract class FoxBehaviorGoal
    extends Goal {
        private final TargetingConditions alertableTargeting;

        FoxBehaviorGoal() {
            this.alertableTargeting = TargetingConditions.m_148352_().m_26883_(12.0).m_148355_().m_26888_((Predicate)new FoxAlertableEntitiesSelector());
        }

        protected boolean hasShelter() {
            BlockPos blockpos = BlockPos.m_274561_((double)NewFox.this.m_20185_(), (double)NewFox.this.m_20191_().f_82292_, (double)NewFox.this.m_20189_());
            return !NewFox.this.m_9236_().m_45527_(blockpos) && NewFox.this.m_21692_(blockpos) >= 0.0f;
        }

        protected boolean alertable() {
            return !NewFox.this.m_9236_().m_45971_(LivingEntity.class, this.alertableTargeting, (LivingEntity)NewFox.this, NewFox.this.m_20191_().m_82377_(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class FoxAlertableEntitiesSelector
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_28653_) {
            if (p_28653_ instanceof NewFox) {
                return false;
            }
            if (!(p_28653_ instanceof Chicken || p_28653_ instanceof Duck || p_28653_ instanceof Rabbit || p_28653_ instanceof Monster)) {
                if (p_28653_ instanceof TamableAnimal) {
                    return !((TamableAnimal)p_28653_).m_21824_();
                }
                if (!(p_28653_ instanceof Player) || !p_28653_.m_5833_() && !((Player)p_28653_).m_7500_()) {
                    if (NewFox.this.trusts(p_28653_.m_20148_())) {
                        return false;
                    }
                    return !p_28653_.m_5803_() && !p_28653_.m_20163_();
                }
                return false;
            }
            return true;
        }
    }
}

