/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.advancement.modifier;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.violetmoon.zeta.advancement.AdvancementModifier;
import org.violetmoon.zeta.api.IMutableAdvancement;
import org.violetmoon.zeta.module.ZetaModule;

public class WaxModifier
extends AdvancementModifier {
    private static final ResourceLocation TARGET_ON = new ResourceLocation("husbandry/wax_on");
    private static final ResourceLocation TARGET_OFF = new ResourceLocation("husbandry/wax_off");
    private final Set<Block> unwaxed;
    private final Set<Block> waxed;

    public WaxModifier(ZetaModule module, Set<Block> unwaxed, Set<Block> waxed) {
        super(module);
        this.unwaxed = unwaxed;
        this.waxed = waxed;
        Preconditions.checkArgument((!unwaxed.isEmpty() || !waxed.isEmpty() ? 1 : 0) != 0, (Object)"Advancement modifier list cant be empty");
    }

    @Override
    public Set<ResourceLocation> getTargets() {
        return ImmutableSet.of((Object)TARGET_ON, (Object)TARGET_OFF);
    }

    @Override
    public boolean apply(ResourceLocation res, IMutableAdvancement adv) {
        CriterionTriggerInstance criterionTriggerInstance;
        String title = res.m_135815_().replaceAll(".+/", "");
        Criterion criterion = adv.getCriterion(title);
        if (criterion != null && (criterionTriggerInstance = criterion.m_11416_()) instanceof ItemUsedOnLocationTrigger.TriggerInstance) {
            ItemUsedOnLocationTrigger.TriggerInstance iib = (ItemUsedOnLocationTrigger.TriggerInstance)criterionTriggerInstance;
            iib.f_285570_.f_285559_ = res.equals((Object)TARGET_ON) ? iib.f_285570_.f_285559_.or(ItemUsedOnLocationTrigger.TriggerInstance.m_285945_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_((BlockPredicate)BlockPredicate.Builder.m_17924_().m_146722_(this.unwaxed).m_17931_()), (ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_((ItemLike[])new ItemLike[]{Items.f_42784_})).f_285570_.f_285559_) : iib.f_285570_.f_285559_.or(ItemUsedOnLocationTrigger.TriggerInstance.m_285945_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_((BlockPredicate)BlockPredicate.Builder.m_17924_().m_146722_(this.waxed).m_17931_()), (ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_((TagKey)ItemTags.f_271207_)).f_285570_.f_285559_);
        }
        return true;
    }
}

