/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import com.google.common.collect.Sets;
import dev.ftb.mods.ftbquests.item.MissingItem;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class NBTUtils {
    public static ItemStack read(CompoundTag nbt, String key) {
        Tag nbt1 = nbt.m_128423_(key);
        if (nbt1 instanceof CompoundTag) {
            return MissingItem.readItem((CompoundTag)nbt1);
        }
        if (nbt1 instanceof StringTag) {
            CompoundTag nbt2 = new CompoundTag();
            nbt2.m_128359_("id", nbt1.m_7916_());
            nbt2.m_128344_("Count", (byte)1);
            return MissingItem.readItem(nbt2);
        }
        return ItemStack.f_41583_;
    }

    public static void write(CompoundTag nbt, String key, ItemStack stack) {
        if (!stack.m_41619_()) {
            CompoundTag nbt1 = MissingItem.writeItem(stack);
            if (nbt1.m_128440_() == 2 && nbt1.m_128451_("Count") == 1) {
                nbt.m_128359_(key, nbt1.m_128461_("id"));
            } else {
                nbt.m_128365_(key, (Tag)nbt1);
            }
        }
    }

    public static boolean compareNbt(@Nullable Tag tagA, @Nullable Tag tagB, boolean fuzzy, boolean compareLists) {
        if (tagA == tagB) {
            return true;
        }
        if (tagA == null) {
            return true;
        }
        if (tagB == null) {
            return false;
        }
        if (!tagA.m_6458_().equals(tagB.m_6458_())) {
            return false;
        }
        if (tagA instanceof CompoundTag) {
            CompoundTag compoundA = (CompoundTag)tagA;
            if (tagB instanceof CompoundTag) {
                CompoundTag compoundB = (CompoundTag)tagB;
                Set keysA = compoundA.m_128431_();
                Set keysB = compoundB.m_128431_();
                if (!(fuzzy || keysA.size() == keysB.size() && Sets.intersection((Set)keysA, (Set)keysB).size() == keysA.size())) {
                    return false;
                }
                return keysA.stream().allMatch(key -> NBTUtils.compareNbt(compoundA.m_128423_(key), compoundB.m_128423_(key), fuzzy, compareLists));
            }
        }
        if (compareLists && tagA instanceof ListTag) {
            ListTag listA = (ListTag)tagA;
            if (tagB instanceof ListTag) {
                ListTag listB = (ListTag)tagB;
                if (listA.isEmpty()) {
                    return listB.isEmpty();
                }
                if (listA.size() != listB.size()) {
                    return false;
                }
                return IntStream.range(0, listA.size()).allMatch(i -> NBTUtils.compareNbt(listA.get(i), listB.get(i), fuzzy, true));
            }
        }
        return tagA.equals(tagB);
    }
}

