/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.api.ItemFilterAdapter;
import dev.ftb.mods.ftbquests.client.gui.ContextMenuBuilder;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.item_filtering.ItemMatchingSystem;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class TaskButton
extends Button {
    private final QuestScreen questScreen;
    Task task;

    public TaskButton(Panel panel, Task task) {
        super(panel, task.getTitle(), Icons.ACCEPT);
        this.questScreen = (QuestScreen)panel.getGui();
        this.task = task;
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            boolean canClick = this.task.isValid() && this.questScreen.file.selfTeamData.canStartTasks(this.task.getQuest()) && !this.questScreen.file.selfTeamData.isCompleted(this.task);
            this.task.onButtonClicked(this, canClick);
        } else if (button.isRight() && this.questScreen.file.canEdit()) {
            ItemTask itemTask;
            List tags;
            this.playClickSound();
            ContextMenuBuilder builder = ContextMenuBuilder.create(this.task, this.questScreen);
            Task task = this.task;
            if (task instanceof ItemTask && !(tags = (itemTask = (ItemTask)task).getItemStack().m_41720_().m_204114_().m_203616_().toList()).isEmpty() && !ItemMatchingSystem.INSTANCE.isItemFilter(itemTask.getItemStack())) {
                for (ItemFilterAdapter adapter : ItemMatchingSystem.INSTANCE.adapters()) {
                    if (!adapter.hasItemTagFilter()) continue;
                    builder.insertAtTop(List.of(new ContextMenuItem((Component)Component.m_237110_((String)"ftbquests.task.ftbquests.item.convert_tag", (Object[])new Object[]{adapter.getName()}), (Icon)ThemeProperties.RELOAD_ICON.get(), b -> {
                        if (tags.size() == 1) {
                            this.setTagFilterAndSave(itemTask, adapter, (TagKey<Item>)((TagKey)tags.get(0)));
                        } else {
                            new TagSelectionScreen(tags, itemTask, adapter).openGui();
                        }
                    })));
                }
            }
            if ((task = this.task.getIcon()) instanceof ItemIcon) {
                ItemIcon itemIcon = (ItemIcon)task;
                builder.insertAtTop(List.of(new ContextMenuItem((Component)Component.m_237115_((String)"ftbquests.gui.use_as_quest_icon"), (Icon)ThemeProperties.EDIT_ICON.get(), b -> {
                    this.task.getQuest().setRawIcon(itemIcon.getStack().m_41777_());
                    this.task.getQuest().clearCachedData();
                    new EditObjectMessage(this.task.getQuest()).sendToServer();
                })));
            }
            builder.openContextMenu(this.getGui());
        }
    }

    private void setTagFilterAndSave(ItemTask itemTask, ItemFilterAdapter adapter, TagKey<Item> tag) {
        itemTask.setStackAndCount(adapter.makeTagFilterStack(tag), itemTask.getItemStack().m_41613_());
        if (itemTask.getRawTitle().isEmpty()) {
            itemTask.setRawTitle("Any #" + tag.f_203868_());
        }
        new EditObjectMessage(itemTask).sendToServer();
    }

    public Optional<PositionedIngredient> getIngredientUnderMouse() {
        return this.task.getIngredient((Widget)this);
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.task);
        this.task.addMouseOverHeader(list, this.questScreen.file.selfTeamData, Minecraft.m_91087_().f_91066_.f_92125_);
        if (this.questScreen.file.selfTeamData.canStartTasks(this.task.getQuest())) {
            long maxp = this.task.getMaxProgress();
            long progress = this.questScreen.file.selfTeamData.getProgress(this.task);
            if (maxp > 1L) {
                if (this.task.hideProgressNumbers()) {
                    list.add((Component)Component.m_237113_((String)("[" + this.task.getRelativeProgressFromChildren(this.questScreen.file.selfTeamData) + "%]")).m_130940_(ChatFormatting.DARK_GREEN));
                } else {
                    String max = TaskButton.isShiftKeyDown() ? Long.toUnsignedString(maxp) : this.task.formatMaxProgress();
                    String prog = TaskButton.isShiftKeyDown() ? Long.toUnsignedString(progress) : this.task.formatProgress(this.questScreen.file.selfTeamData, progress);
                    String s = (progress > maxp ? max : prog) + " / " + max;
                    if (maxp < 100L) {
                        list.add((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.DARK_GREEN));
                    } else {
                        list.add((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237113_((String)(" [" + this.task.getRelativeProgressFromChildren(this.questScreen.file.selfTeamData) + "%]")).m_130940_(ChatFormatting.DARK_GRAY)));
                    }
                }
            }
        }
        if (this.task.isOptionalForProgression()) {
            list.add((Component)Component.m_237115_((String)"ftbquests.quest.misc.optional").m_130940_(ChatFormatting.GRAY));
        }
        this.task.addMouseOverText(list, this.questScreen.file.selfTeamData);
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(graphics, theme, x, y, w, h);
        }
    }

    public void drawIcon(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        this.task.drawGUI(this.questScreen.file.selfTeamData, graphics, x, y, w, h);
    }

    public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        int bs = h >= 32 ? 32 : 16;
        GuiHelper.setupDrawing();
        this.drawBackground(graphics, theme, x, y, w, h);
        this.drawIcon(graphics, theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        if (this.questScreen.file.selfTeamData == null) {
            return;
        }
        if (this.questScreen.getContextMenu().isPresent()) {
            // empty if block
        }
        PoseStack poseStack = graphics.m_280168_();
        if (this.questScreen.file.selfTeamData.isCompleted(this.task)) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 200.0f);
            RenderSystem.enableBlend();
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(graphics, x + w - 9, y + 1, 8, 8);
            poseStack.m_85849_();
        } else {
            MutableComponent s = this.task.getButtonText();
            if (s.m_214077_() != ComponentContents.f_237124_) {
                poseStack.m_85836_();
                poseStack.m_252880_((float)x + 19.0f - (float)theme.getStringWidth((FormattedText)s) / 2.0f, (float)y + 15.0f, 200.0f);
                poseStack.m_85841_(0.5f, 0.5f, 1.0f);
                RenderSystem.enableBlend();
                theme.drawString(graphics, (Object)s, 0, 0, Color4I.WHITE, 2);
                poseStack.m_85849_();
            }
        }
    }

    private class TagSelectionScreen
    extends AbstractButtonListScreen {
        private final List<TagKey<Item>> tags;
        private final ItemTask itemTask;
        private final ItemFilterAdapter adapter;

        public TagSelectionScreen(List<TagKey<Item>> tags, ItemTask itemTask, ItemFilterAdapter adapter) {
            this.itemTask = itemTask;
            this.tags = tags;
            this.adapter = adapter;
            this.setTitle((Component)Component.m_237115_((String)"ftbquests.task.ftbquests.item.select_tag"));
            this.showBottomPanel(false);
            this.showCloseButton(true);
        }

        public void addButtons(Panel panel) {
            this.tags.stream().sorted(Comparator.comparing(itemTagKey -> itemTagKey.f_203868_().toString())).forEach(tag -> panel.add((Widget)new TagSelectionButton(panel, (TagKey<Item>)tag)));
        }

        public boolean onInit() {
            int titleW = this.getTheme().getStringWidth((FormattedText)this.getTitle());
            int w = this.tags.stream().map(t -> this.getTheme().getStringWidth(t.f_203868_().toString())).max(Comparator.naturalOrder()).orElse(100);
            this.setSize(Math.max(titleW, w) + 20, this.getScreen().m_85446_() * 3 / 4);
            return true;
        }

        protected void doCancel() {
            TaskButton.this.questScreen.openGui();
        }

        protected void doAccept() {
            TaskButton.this.questScreen.openGui();
        }

        private class TagSelectionButton
        extends SimpleTextButton {
            private final TagKey<Item> tag;

            public TagSelectionButton(Panel panel, TagKey<Item> tag) {
                super(panel, (Component)Component.m_237113_((String)tag.f_203868_().toString()), (Icon)Color4I.empty());
                this.tag = tag;
            }

            public void onClicked(MouseButton button) {
                TaskButton.this.questScreen.openGui();
                TaskButton.this.setTagFilterAndSave(TagSelectionScreen.this.itemTask, TagSelectionScreen.this.adapter, this.tag);
            }

            public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                if (this.isMouseOver) {
                    Color4I.WHITE.withAlpha(30).draw(graphics, x, y, w, h);
                }
                Color4I.GRAY.withAlpha(40).draw(graphics, x, y + h, w, 1);
            }
        }
    }
}

