/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import virtuoel.no_fog.NoFogClient;
import virtuoel.no_fog.util.VersionUtils;

public class ReflectionUtils {
    public static final MethodHandle FOG_DENSITY;
    public static final MethodHandle FOG_START;
    public static final MethodHandle FOG_END;
    public static final ResourceKey<Registry<Fluid>> FLUID_KEY;
    public static final ResourceKey<Registry<Biome>> BIOME_KEY;
    public static final ResourceKey<Registry<DimensionType>> DIMENSION_TYPE_KEY;
    public static final Registry<Biome> BUILTIN_BIOME_REGISTRY;
    public static final MobEffect BLINDNESS;
    public static final MobEffect DARKNESS;
    public static final ReflectionUtils INSTANCE;

    public static <E> Registry<E> getDynamicRegistry(CommonLevelAccessor w, ResourceKey<? extends Registry<E>> key) {
        return w.m_9598_().m_175515_(key);
    }

    public static ResourceLocation constructIdentifier(String id) {
        return new ResourceLocation(id);
    }

    public static ResourceLocation constructIdentifier(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static String getBiomeId(Entity entity) {
        Level world = entity.m_20193_();
        Vec3 pos = entity.m_20182_();
        Biome biome = (Biome)world.m_204166_(new BlockPos(Mth.m_14107_((double)pos.m_7096_()), Mth.m_14107_((double)pos.m_7098_()), Mth.m_14107_((double)pos.m_7094_()))).m_203334_();
        return ReflectionUtils.getId(ReflectionUtils.getDynamicRegistry((CommonLevelAccessor)world, BIOME_KEY), biome).toString();
    }

    public static boolean hasStatusEffect(LivingEntity entity, MobEffect effect) {
        return entity.m_21023_(effect);
    }

    public static Set<ResourceLocation> getIds(Registry<?> registry) {
        return registry.m_6566_();
    }

    public static <V> ResourceLocation getId(Registry<V> registry, V entry) {
        return registry.m_7981_(entry);
    }

    public static void setFogDensity(float f) {
        if (FOG_DENSITY != null) {
            try {
                FOG_DENSITY.invokeExact(f);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void setFogStart(float f) {
        if (FOG_START != null) {
            try {
                FOG_START.invokeExact(f);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void setFogEnd(float f) {
        if (FOG_END != null) {
            try {
                FOG_END.invokeExact(f);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T> T getFieldValue(Field field, Object object, Supplier<T> defaultValue) {
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return defaultValue.get();
        }
    }

    public static Optional<Field> getField(Optional<Class<?>> classObj, String fieldName) {
        return classObj.map(c -> {
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException | SecurityException e) {
                return null;
            }
        });
    }

    public static <T> T getFieldValue(Optional<Class<?>> classObj, String fieldName, Object object, T defaultValue) {
        return (T)ReflectionUtils.getField(classObj, fieldName).map(f -> {
            try {
                return f.get(object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return defaultValue;
            }
        }).orElse(defaultValue);
    }

    public static void setField(Optional<Class<?>> classObj, String fieldName, Object object, Object value) {
        ReflectionUtils.getField(classObj, fieldName).ifPresent(f -> {
            try {
                f.set(object, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        });
    }

    public static Optional<Method> getMethod(Optional<Class<?>> classObj, String methodName, Class<?> ... args) {
        return classObj.map(c -> {
            try {
                Method m = c.getMethod(methodName, args);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
    }

    public static <T> Optional<Constructor<T>> getConstructor(Optional<Class<T>> clazz, Class<?> ... params) {
        return clazz.map(c -> {
            try {
                return c.getConstructor(params);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
    }

    public static Optional<Class<?>> getClass(String className, String ... classNames) {
        Optional<Class<?>> ret = ReflectionUtils.getClass(className);
        for (String name : classNames) {
            if (ret.isPresent()) {
                return ret;
            }
            ret = ReflectionUtils.getClass(name);
        }
        return ret;
    }

    public static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private ReflectionUtils() {
    }

    static {
        Int2ObjectArrayMap h = new Int2ObjectArrayMap();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String mapped = "unset";
        try {
            boolean is116;
            boolean bl = is116 = VersionUtils.MINOR == 16;
            if (is116) {
                Class<?> clazz = Class.forName("com.mojang.blaze3d.systems.RenderSystem");
                Method m = clazz.getMethod("fogDensity", Float.TYPE);
                h.put(0, (Object)lookup.unreflect(m));
                m = clazz.getMethod("fogStart", Float.TYPE);
                h.put(1, (Object)lookup.unreflect(m));
                m = clazz.getMethod("fogEnd", Float.TYPE);
                h.put(2, (Object)lookup.unreflect(m));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException e1) {
            NoFogClient.LOGGER.error("Current name lookup: {}", new Object[]{mapped});
            NoFogClient.LOGGER.catching((Throwable)e1);
        }
        FOG_DENSITY = (MethodHandle)h.get(0);
        FOG_START = (MethodHandle)h.get(1);
        FOG_END = (MethodHandle)h.get(2);
        FLUID_KEY = Registries.f_256808_;
        BIOME_KEY = Registries.f_256952_;
        DIMENSION_TYPE_KEY = Registries.f_256787_;
        BUILTIN_BIOME_REGISTRY = null;
        BLINDNESS = MobEffects.f_19610_;
        DARKNESS = MobEffects.f_216964_;
        INSTANCE = new ReflectionUtils();
    }
}

