/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.SubCategoryListEntry;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModLoadingContext;
import org.apache.commons.lang3.tuple.Triple;
import virtuoel.no_fog.api.NoFogConfig;
import virtuoel.no_fog.util.ConfigUtils;
import virtuoel.no_fog.util.FogToggles;
import virtuoel.no_fog.util.I18nUtils;
import virtuoel.no_fog.util.NoFogConfigImpl;
import virtuoel.no_fog.util.ReflectionUtils;
import virtuoel.no_fog.util.TriState;
import virtuoel.no_fog.util.VersionUtils;

public class AutoConfigUtils {
    public static final Supplier<NoFogConfig> CONFIG = () -> (NoFogConfig)AutoConfig.getConfigHolder(NoFogConfigImpl.class).getConfig();
    private static final ConfigEntryBuilder ENTRY_BUILDER = ConfigEntryBuilder.create();
    private static boolean tagsFailed = false;

    public static void initialize() {
        AutoConfig.register(NoFogConfigImpl.class, GsonConfigSerializer::new);
        GuiRegistry registry = AutoConfig.getGuiRegistry(NoFogConfigImpl.class);
        registry.registerPredicateProvider(AutoConfigUtils::globalToggleEntry, f -> f.getName().equals("globalToggles"));
        registry.registerPredicateProvider(AutoConfigUtils::dimensionToggleMapEntries, f -> f.getName().equals("dimensionToggles"));
        registry.registerPredicateProvider(AutoConfigUtils::biomeToggleMapEntries, f -> f.getName().equals("biomeToggles"));
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> (Screen)AutoConfig.getConfigScreen(NoFogConfigImpl.class, (Screen)screen).get()));
    }

    private static List<AbstractConfigListEntry> globalToggleEntry(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
        LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
        entries.add((AbstractConfigListEntry)ENTRY_BUILDER.startSubCategory(I18nUtils.translate("text.no_fog.config.category.global", "Global settings"), AutoConfigUtils.addToggleEntries(ReflectionUtils.getFieldValue(field, config, () -> new FogToggles(new Object[0])), Collections.emptyList())).build());
        return entries;
    }

    private static List<AbstractConfigListEntry> dimensionToggleMapEntries(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registryAccess) {
        Map data = ReflectionUtils.getFieldValue(field, config, HashMap::new);
        LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
        LinkedList<SubCategoryListEntry> dimensionEntries = new LinkedList<SubCategoryListEntry>();
        ConfigUtils.populateDimensionToggles(data);
        List ids = data.keySet().stream().sorted((l, r) -> l.compareTo((String)r)).collect(Collectors.toList());
        for (String id : ids) {
            dimensionEntries.add(ENTRY_BUILDER.startSubCategory(I18nUtils.literal(id, new Object[0]), AutoConfigUtils.addToggleEntries((FogToggles)data.get(id), Collections.singletonList(id))).build());
        }
        entries.add((AbstractConfigListEntry)ENTRY_BUILDER.startSubCategory(I18nUtils.translate("text.no_fog.config.category.dimensions", "Dimension Type settings"), dimensionEntries).build());
        return entries;
    }

    private static List<AbstractConfigListEntry> biomeToggleMapEntries(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registryAccess) {
        Map data = ReflectionUtils.getFieldValue(field, config, HashMap::new);
        LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
        LinkedList<SubCategoryListEntry> biomeEntries = new LinkedList<SubCategoryListEntry>();
        ConfigUtils.populateBiomeToggles(data);
        List idData = data.keySet().stream().map(i -> {
            String key = Util.m_137492_((String)"biome", (ResourceLocation)ReflectionUtils.constructIdentifier(i));
            return Triple.of((Object)i, (Object)key, (Object)I18n.m_118938_((String)key, (Object[])new Object[0]));
        }).sorted((l, r) -> ((String)l.getRight()).compareTo((String)r.getRight())).collect(Collectors.toList());
        for (Triple id : idData) {
            String idStr = (String)id.getLeft();
            String translationKey = (String)id.getMiddle();
            biomeEntries.add(ENTRY_BUILDER.startSubCategory(I18nUtils.translate(translationKey, idStr), AutoConfigUtils.addToggleEntries((FogToggles)data.get(idStr), Arrays.asList(idStr, translationKey, (String)id.getRight()))).setTooltip(new Component[]{I18nUtils.literal(idStr, new Object[0])}).build());
        }
        if (!biomeEntries.isEmpty()) {
            entries.add((AbstractConfigListEntry)ENTRY_BUILDER.startSubCategory(I18nUtils.translate("text.no_fog.config.category.biomes", "Biome settings"), biomeEntries).build());
        }
        return entries;
    }

    private static List<AbstractConfigListEntry> addToggleEntries(FogToggles data, Collection<String> tags) {
        LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
        String enabledKey = "text.no_fog.config.default.enabled";
        String enabledDefault = "Default: enabled";
        String disabledKey = "text.no_fog.config.default.disabled";
        String disabledDefault = "Default: disabled";
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.sky_fog", data.skyFog, newValue -> {
            data.skyFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.enabled", "Default: enabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.terrain_fog", data.terrainFog, newValue -> {
            data.terrainFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.thick_fog", data.thickFog, newValue -> {
            data.thickFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.thick_fog.tooltip", "Enable thick fog"), I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.water_fog", data.waterFog, newValue -> {
            data.waterFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.lava_fog", data.lavaFog, newValue -> {
            data.lavaFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        if (VersionUtils.MINOR >= 17) {
            entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.powder_snow_fog", data.powderSnowFog, newValue -> {
                data.powderSnowFog = newValue;
            }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        }
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.blindness_fog", data.blindnessFog, newValue -> {
            data.blindnessFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.enabled", "Default: enabled")));
        if (VersionUtils.MINOR >= 19) {
            entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.darkness_fog", data.darknessFog, newValue -> {
                data.darknessFog = newValue;
            }, I18nUtils.translate("text.no_fog.config.default.enabled", "Default: enabled")));
        }
        if (!tagsFailed && tags != null && !tags.isEmpty()) {
            try {
                for (AbstractConfigListEntry entry : entries) {
                    entry.appendSearchTags(tags);
                }
            }
            catch (Throwable e) {
                tagsFailed = true;
            }
        }
        return entries;
    }

    private static EnumListEntry<TriState> triStateEntry(String key, TriState value, Consumer<TriState> saveConsumer, Component ... tooltip) {
        return ENTRY_BUILDER.startEnumSelector(I18nUtils.translate(key, key), TriState.class, (Enum)(value != null ? value : TriState.DEFAULT)).setDefaultValue((Enum)TriState.DEFAULT).setSaveConsumer(saveConsumer).setTooltip(tooltip).build();
    }
}

