/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.mixin.client.compat119plus;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import virtuoel.no_fog.NoFogClient;
import virtuoel.no_fog.util.FogToggleType;
import virtuoel.no_fog.util.ReflectionUtils;

@Mixin(value={FogRenderer.class}, priority=910)
public abstract class BackgroundRendererMixin {
    @Inject(method={"applyFog"}, at={@At(value="RETURN")})
    private static void applyFogModifyDistance(Camera camera, FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, float tickDelta, CallbackInfo info) {
        Entity entity;
        FogType cameraSubmersionType = camera.m_167685_();
        if (!NoFogClient.isToggleEnabled(BackgroundRendererMixin.getFogType(fogType, thickFog, cameraSubmersionType, entity = camera.m_90592_()), entity)) {
            RenderSystem.setShaderFogStart((float)-8.0f);
            RenderSystem.setShaderFogEnd((float)1000000.0f);
            RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
        }
    }

    @Unique
    private static FogToggleType getFogType(FogRenderer.FogMode fogType, boolean thickFog, FogType cameraSubmersionType, Entity entity) {
        if (cameraSubmersionType == FogType.LAVA) {
            return FogToggleType.LAVA;
        }
        if (cameraSubmersionType == FogType.POWDER_SNOW) {
            return FogToggleType.POWDER_SNOW;
        }
        if (entity instanceof LivingEntity && ReflectionUtils.hasStatusEffect((LivingEntity)entity, ReflectionUtils.BLINDNESS)) {
            return FogToggleType.BLINDNESS;
        }
        if (entity instanceof LivingEntity && ReflectionUtils.hasStatusEffect((LivingEntity)entity, ReflectionUtils.DARKNESS)) {
            return FogToggleType.DARKNESS;
        }
        if (cameraSubmersionType == FogType.WATER) {
            return FogToggleType.WATER;
        }
        if (thickFog) {
            return FogToggleType.THICK;
        }
        if (fogType == FogRenderer.FogMode.FOG_SKY) {
            return FogToggleType.SKY;
        }
        return FogToggleType.TERRAIN;
    }
}

