/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.mixin.client.compat1182;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import virtuoel.no_fog.NoFogClient;
import virtuoel.no_fog.util.FogToggleType;
import virtuoel.no_fog.util.ReflectionUtils;

@Mixin(value={FogRenderer.class}, priority=910)
public abstract class BackgroundRendererMixin {
    @Inject(method={"setupFog(Lnet/minecraft/client/render/Camera;Lnet/minecraft/client/render/BackgroundRenderer$FogType;FZF)V"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="RETURN")})
    @Dynamic
    private static void applyFogModifyDistance(Camera camera, FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, float tickDelta, CallbackInfo info, FogType cameraSubmersionType, Entity entity, FogShape fogShape, float hook, float start, float end) {
        float modifiedStart = BackgroundRendererMixin.getFogDistance(fogType, viewDistance, thickFog, cameraSubmersionType, entity, start, true);
        float modifiedEnd = BackgroundRendererMixin.getFogDistance(fogType, viewDistance, thickFog, cameraSubmersionType, entity, end, false);
        if (modifiedStart != start) {
            RenderSystem.setShaderFogStart((float)modifiedStart);
        }
        if (modifiedEnd != end) {
            RenderSystem.setShaderFogEnd((float)modifiedEnd);
        }
    }

    @Unique
    private static float getFogDistance(FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, FogType cameraSubmersionType, Entity entity, float fogDistance, boolean start) {
        FogToggleType type = cameraSubmersionType == FogType.LAVA ? FogToggleType.LAVA : (cameraSubmersionType == FogType.POWDER_SNOW ? FogToggleType.POWDER_SNOW : (entity instanceof LivingEntity && ReflectionUtils.hasStatusEffect((LivingEntity)entity, ReflectionUtils.BLINDNESS) ? FogToggleType.BLINDNESS : (cameraSubmersionType == FogType.WATER ? FogToggleType.WATER : (thickFog ? FogToggleType.THICK : (fogType == FogRenderer.FogMode.FOG_SKY ? FogToggleType.SKY : FogToggleType.TERRAIN)))));
        return NoFogClient.getFogDistance(type, entity, fogDistance, start);
    }
}

