/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;
import virtuoel.no_fog.api.NoFogConfig;
import virtuoel.no_fog.util.AutoConfigUtils;
import virtuoel.no_fog.util.DummyNoFogConfig;
import virtuoel.no_fog.util.FogToggleType;
import virtuoel.no_fog.util.FogToggles;
import virtuoel.no_fog.util.ModLoaderUtils;
import virtuoel.no_fog.util.ReflectionUtils;

@Mod(value="no_fog")
public class NoFogClient {
    public static final String MOD_ID = "no_fog";
    public static final ILogger LOGGER = MixinService.getService().getLogger("no_fog");
    public static final boolean CONFIGS_LOADED = ModLoaderUtils.isModLoaded("cloth_config") || ModLoaderUtils.isModLoaded("cloth-config") || ModLoaderUtils.isModLoaded("cloth-config2");
    public static final Supplier<NoFogConfig> CONFIG = !CONFIGS_LOADED ? () -> DummyNoFogConfig.INSTANCE : AutoConfigUtils.CONFIG;
    public static final float FOG_START = -8.0f;
    public static final float FOG_END = 1000000.0f;

    public NoFogClient() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remoteVersion, isServer) -> true));
        if (CONFIGS_LOADED) {
            AutoConfigUtils.initialize();
        }
        ReflectionUtils.INSTANCE.getClass();
    }

    public static float getFogDistance(FogToggleType type, Entity entity, float fogDistance, boolean start) {
        return NoFogClient.isToggleEnabled(type, entity) ? fogDistance : (start ? -8.0f : 1000000.0f);
    }

    public static boolean isToggleEnabled(FogToggleType type, Entity entity) {
        String dimension = entity.m_20193_().m_46472_().m_135782_().toString();
        NoFogConfig config = CONFIG.get();
        FogToggles globalToggles = config.getGlobalToggles();
        FogToggles dimensionToggles = config.getDimensionToggles().computeIfAbsent(dimension, xva$0 -> new FogToggles(xva$0));
        String biomeId = ReflectionUtils.getBiomeId(entity);
        FogToggles biomeToggles = config.getBiomeToggles().computeIfAbsent(biomeId, xva$0 -> new FogToggles(xva$0));
        return type.apply(biomeToggles).orElse(type.apply(dimensionToggles).orElse(type.apply(globalToggles).orElse(type.defaultToggle)));
    }

    public static ResourceLocation id(String name) {
        return ReflectionUtils.constructIdentifier(MOD_ID, name);
    }
}

