/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.render.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FrameableModel
implements IUnbakedGeometry<FrameableModel> {
    public static final Logger LOGGER = LogManager.getLogger();
    public ResourceLocation parent = null;
    public Multimap<MaterialSide, FramingCandidate> materials;
    public List<ResourceLocation> inherits = Collections.emptyList();

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        BakedModel parent = null;
        if (this.parent != null) {
            parent = baker.bake(this.parent, modelState, spriteGetter);
        }
        HashMultimap bakedSides = this.materials.entries().stream().collect(Collector.of(HashMultimap::create, (map, entry) -> map.put((Object)((MaterialSide)((Object)((Object)entry.getKey()))), (Object)((FramingCandidate)entry.getValue()).baked(context, spriteGetter, modelState, modelLocation)), (first, second) -> {
            first.putAll((Multimap)second);
            return first;
        }, Collector.Characteristics.UNORDERED));
        for (ResourceLocation rl : this.inherits) {
            BakedModel baked = baker.bake(rl, modelState, spriteGetter);
            if (baked instanceof Baked) {
                for (Map.Entry entry2 : ((Baked)baked).bakedSides.entries()) {
                    bakedSides.put((Object)((MaterialSide)((Object)entry2.getKey())), (Object)((FramingCandidate.Baked)entry2.getValue()));
                }
                continue;
            }
            LOGGER.warn("Inherited model must be a frameable model! Got: " + (Serializable)(baked == null ? "null" : baked.getClass()));
        }
        RenderTypeGroup rtg = context.getRenderType(new ResourceLocation("translucent"));
        return new Baked(parent, (Multimap<MaterialSide, FramingCandidate.Baked>)bakedSides, List.of(rtg.entity()), List.of(rtg.entityFabulous()));
    }

    private static class Baked
    implements IDynamicBakedModel {
        final Multimap<MaterialSide, FramingCandidate.Baked> bakedSides;
        @Nullable
        private final BakedModel parent;
        private final ItemOverrides overrides;
        private final List<RenderType> itemRenderTypes;
        private final List<RenderType> itemRenderTypesFabulous;

        public Baked(final @Nullable BakedModel parent, final Multimap<MaterialSide, FramingCandidate.Baked> bakedSides, final List<RenderType> itemRenderTypes, final List<RenderType> itemRenderTypesFabulous) {
            this.bakedSides = bakedSides;
            this.parent = parent;
            this.itemRenderTypes = itemRenderTypes;
            this.itemRenderTypesFabulous = itemRenderTypesFabulous;
            this.overrides = new ItemOverrides(){

                @Nonnull
                @ParametersAreNonnullByDefault
                public BakedModel m_173464_(BakedModel model, final ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int idkMan) {
                    return new Baked(parent, bakedSides, itemRenderTypes, itemRenderTypesFabulous){

                        @Override
                        @Nonnull
                        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
                            if (stack.m_41782_()) {
                                CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
                                ModelData.Builder builder = ModelData.builder();
                                for (MaterialSide material : MaterialSide.values()) {
                                    String key = material.getKey();
                                    if (key == null || !tag.m_128441_(key)) continue;
                                    builder.with(material.property, (Object)ItemStack.m_41712_((CompoundTag)tag.m_128469_(key)));
                                }
                                extraData = builder.build();
                            }
                            return super.getQuads(state, side, rand, extraData, layer);
                        }

                        @Override
                        @Nonnull
                        public ItemOverrides m_7343_() {
                            return ItemOverrides.f_111734_;
                        }
                    };
                }
            };
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (MaterialSide material : MaterialSide.values()) {
                if (layer != null && material.type != layer) continue;
                for (FramingCandidate.Baked baked : this.bakedSides.get((Object)material)) {
                    if (baked.getEnclosing().face.f_111354_ != side || !baked.getEnclosing().condition.test(extraData)) continue;
                    quads.add(baked.getQuad(this.resolve(extraData, material)));
                }
            }
            return quads;
        }

        @Nullable
        private ItemStack resolve(ModelData data, MaterialSide material) {
            if (material == MaterialSide.OVERLAY) {
                return null;
            }
            ItemStack stack = (ItemStack)data.get(material.property);
            if (material != MaterialSide.SIDE && (stack == null || stack.m_41619_())) {
                return this.resolve(data, MaterialSide.SIDE);
            }
            return stack;
        }

        public boolean m_7541_() {
            return this.parent != null && this.parent.m_7541_();
        }

        public boolean m_7539_() {
            return this.parent != null && this.parent.m_7539_();
        }

        public boolean m_7547_() {
            return this.parent != null && this.parent.m_7547_();
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.getParticleIcon(ModelData.EMPTY);
        }

        @NotNull
        public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
            return this.bakedSides.get((Object)MaterialSide.SIDE).stream().findFirst().map(mat -> mat.getSpriteOrRaw(this.resolve(data, MaterialSide.SIDE))).orElseGet(() -> this.parent == null ? (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_()) : this.parent.getParticleIcon(ModelData.EMPTY));
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public ItemTransforms m_7442_() {
            if (this.parent != null) {
                return this.parent.m_7442_();
            }
            return ItemTransforms.f_111786_;
        }

        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            return ChunkRenderTypeSet.of(MaterialSide.getRenderTypes());
        }

        public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
            return fabulous ? this.itemRenderTypesFabulous : this.itemRenderTypes;
        }
    }

    public static enum MaterialSide {
        SIDE(RenderType.m_110457_()),
        FRONT(RenderType.m_110457_()),
        TRIM(RenderType.m_110457_()),
        OVERLAY(RenderType.m_110466_());

        public final ModelProperty<ItemStack> property = new ModelProperty();
        private final RenderType type;

        private MaterialSide(RenderType type) {
            this.type = type;
        }

        public static List<RenderType> getRenderTypes() {
            return List.of(MaterialSide.SIDE.type, MaterialSide.OVERLAY.type);
        }

        @Nullable
        public String getKey() {
            if (this != OVERLAY) {
                return "Mat" + this.name().charAt(0);
            }
            return null;
        }
    }

    public static class FramingCandidate {
        public static final FaceBakery FACE_BAKERY = new FaceBakery();
        public Vector3f start;
        public Vector3f end;
        public Direction direction;
        public BlockElementFace face;
        public Condition condition = Condition.ALWAYS;

        public Baked baked(IGeometryBakingContext context, Function<Material, TextureAtlasSprite> spriteGetter, ModelState state, ResourceLocation modelLocation) {
            return new Baked(context, spriteGetter, state, modelLocation);
        }

        public static enum Condition implements Predicate<ModelData>
        {
            LOCKED(data -> {
                IDrawerAttributes attr = (IDrawerAttributes)data.get(BlockEntityDrawers.ATTRIBUTES);
                return attr != null && (attr.isItemLocked(LockAttribute.LOCK_EMPTY) || attr.isItemLocked(LockAttribute.LOCK_POPULATED));
            }),
            ALWAYS(data -> true);

            private final Predicate<ModelData> predicate;

            private Condition(Predicate<ModelData> predicate) {
                this.predicate = predicate;
            }

            @Override
            public boolean test(ModelData data) {
                return this.predicate.test(data);
            }
        }

        public class Baked {
            private final Function<TextureAtlasSprite, BakedQuad> quadSupplier;
            private final Cache<TextureAtlasSprite, BakedQuad> quadCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
            private final TextureAtlasSprite rawSprite;

            public FramingCandidate getEnclosing() {
                return FramingCandidate.this;
            }

            private Baked(IGeometryBakingContext context, Function<Material, TextureAtlasSprite> spriteGetter, ModelState state, ResourceLocation modelLocation) {
                Material rawMaterial = context.getMaterial(FramingCandidate.this.face.f_111356_);
                this.rawSprite = spriteGetter.apply(rawMaterial);
                FramingCandidate.this.face.f_111357_.m_111394_(this.getFaceUvs(FramingCandidate.this.direction));
                this.quadSupplier = sprite -> FACE_BAKERY.m_111600_(FramingCandidate.this.start, FramingCandidate.this.end, FramingCandidate.this.face, sprite, FramingCandidate.this.direction, state, null, true, modelLocation);
            }

            public float[] getFaceUvs(Direction facing) {
                float[] fArray;
                switch (facing) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOWN: {
                        float[] fArray2 = new float[4];
                        fArray2[0] = FramingCandidate.this.start.x();
                        fArray2[1] = 16.0f - FramingCandidate.this.end.z();
                        fArray2[2] = FramingCandidate.this.end.x();
                        fArray = fArray2;
                        fArray2[3] = 16.0f - FramingCandidate.this.start.z();
                        break;
                    }
                    case UP: {
                        float[] fArray3 = new float[4];
                        fArray3[0] = FramingCandidate.this.start.x();
                        fArray3[1] = FramingCandidate.this.start.z();
                        fArray3[2] = FramingCandidate.this.end.x();
                        fArray = fArray3;
                        fArray3[3] = FramingCandidate.this.end.z();
                        break;
                    }
                    case NORTH: {
                        float[] fArray4 = new float[4];
                        fArray4[0] = 16.0f - FramingCandidate.this.end.x();
                        fArray4[1] = 16.0f - FramingCandidate.this.end.y();
                        fArray4[2] = 16.0f - FramingCandidate.this.start.x();
                        fArray = fArray4;
                        fArray4[3] = 16.0f - FramingCandidate.this.start.y();
                        break;
                    }
                    case SOUTH: {
                        float[] fArray5 = new float[4];
                        fArray5[0] = FramingCandidate.this.start.x();
                        fArray5[1] = 16.0f - FramingCandidate.this.end.y();
                        fArray5[2] = FramingCandidate.this.end.x();
                        fArray = fArray5;
                        fArray5[3] = 16.0f - FramingCandidate.this.start.y();
                        break;
                    }
                    case WEST: {
                        float[] fArray6 = new float[4];
                        fArray6[0] = FramingCandidate.this.start.z();
                        fArray6[1] = 16.0f - FramingCandidate.this.end.y();
                        fArray6[2] = FramingCandidate.this.end.z();
                        fArray = fArray6;
                        fArray6[3] = 16.0f - FramingCandidate.this.start.y();
                        break;
                    }
                    case EAST: {
                        float[] fArray7 = new float[4];
                        fArray7[0] = 16.0f - FramingCandidate.this.end.z();
                        fArray7[1] = 16.0f - FramingCandidate.this.end.y();
                        fArray7[2] = 16.0f - FramingCandidate.this.start.z();
                        fArray = fArray7;
                        fArray7[3] = 16.0f - FramingCandidate.this.start.y();
                    }
                }
                return fArray;
            }

            public BakedQuad getQuad(@Nullable ItemStack stack) {
                TextureAtlasSprite sprite = this.getSpriteOrRaw(stack);
                try {
                    return (BakedQuad)this.quadCache.get((Object)sprite, () -> this.quadSupplier.apply(sprite));
                }
                catch (ExecutionException e) {
                    return this.quadSupplier.apply(sprite);
                }
            }

            public TextureAtlasSprite getSpriteOrRaw(@Nullable ItemStack stack) {
                return stack == null || stack.m_41619_() ? this.rawSprite : this.getSprite(stack);
            }

            private TextureAtlasSprite getSprite(ItemStack stack) {
                return Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0).getParticleIcon(ModelData.EMPTY);
            }
        }
    }
}

