/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.utils;

import com.heaser.pipeconnector.PipeConnector;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockEqualsChecker;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockGetter;
import com.heaser.pipeconnector.compatibility.CompatibilityPlacer;
import com.heaser.pipeconnector.config.PipeConnectorConfig;
import com.heaser.pipeconnector.constants.BridgeType;
import com.heaser.pipeconnector.particles.ParticleHelper;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.PreviewInfo;
import com.heaser.pipeconnector.utils.TagUtils;
import com.heaser.pipeconnector.utils.pathfinding.ManhattanAlgorithm;
import com.heaser.pipeconnector.utils.pathfinding.PathfindingAStarAlgorithm;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class PipeConnectorUtils {
    public static boolean connectPathWithSegments(Player player, BlockPos start, BlockPos end, int depth, UseOnContext context, BridgeType bridgeType, boolean utilizeExistingPipes) {
        Level level = player.m_9236_();
        ItemStack itemToPlace = player.m_21206_();
        Block blockToPlace = CompatibilityBlockGetter.getInstance().getBlock(itemToPlace);
        Map<BlockPos, BlockState> blockPosMap = PipeConnectorUtils.getBlockPosMap(start, end, depth, level, bridgeType, blockToPlace, itemToPlace, utilizeExistingPipes, player);
        PipeConnector.LOGGER.debug(blockPosMap.toString());
        boolean isCreativeMode = player.m_150110_().f_35937_;
        int pipeLimit = (Integer)PipeConnectorConfig.MAX_ALLOWED_PIPES_TO_PLACE.get();
        int numOfPipes = PipeConnectorUtils.getNumberOfPipesInInventory(player);
        int missingPipes = PipeConnectorUtils.getMissingPipesInInventory(player, numOfPipes, blockPosMap, blockToPlace);
        if (missingPipes > 0) {
            PipeConnector.LOGGER.debug("Not enough pipes in inventory, missing " + missingPipes + " pipes.");
            player.m_5661_((Component)Component.m_237110_((String)"item.pipe_connector.message.notEnoughPipes", (Object[])new Object[]{missingPipes}).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}), true);
            return false;
        }
        if (pipeLimit < blockPosMap.size()) {
            PipeConnector.LOGGER.debug("Unable to place more than " + pipeLimit + " at once");
            player.m_5661_((Component)Component.m_237110_((String)"item.pipe_connector.message.reachedPipeLimit", (Object[])new Object[]{pipeLimit}).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}), true);
            return false;
        }
        for (Map.Entry<BlockPos, BlockState> set : blockPosMap.entrySet()) {
            String blockName = set.getValue().m_60734_().m_49954_().getString();
            if (GeneralUtils.isNotBreakable(level, set.getKey())) {
                player.m_5661_((Component)Component.m_237110_((String)"item.pipe_connector.message.unbreakableBlockReached", (Object[])new Object[]{blockName}).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_RED}), true);
                return false;
            }
            if (!GeneralUtils.hasInventoryCapabilities(level, set.getKey()) || !TagUtils.getPreventInventoryBlockBreaking(context.m_43722_())) continue;
            player.m_5661_((Component)Component.m_237110_((String)"item.pipe_connector.gui.button.tooltip.disabledInventoryInPath", (Object[])new Object[]{blockName}).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_RED}), true);
            return false;
        }
        for (Map.Entry<BlockPos, BlockState> set : blockPosMap.entrySet()) {
            CompatibilityBlockEqualsChecker.getInstance();
            if (CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(set.getKey(), blockToPlace, itemToPlace, level)) continue;
            if (!isCreativeMode) {
                PipeConnectorUtils.reduceNumberOfPipesInInventory(player);
            }
            ParticleHelper.serverSpawnMarkerParticle((ServerLevel)level, set.getKey());
            PipeConnectorUtils.breakAndSetBlock(level, set.getKey(), blockToPlace, player, context);
        }
        return true;
    }

    public static int getMissingPipesInInventory(Player player, int NumberOfPipesInInventory, int PathSize) {
        boolean isCreativeMode = player.m_150110_().f_35937_;
        if (isCreativeMode) {
            return 0;
        }
        return PathSize - NumberOfPipesInInventory;
    }

    public static int getMissingPipesInInventory(Player player, int NumberOfPipesInInventory, Map<BlockPos, BlockState> blockPosMap, Block block) {
        int existingPipesInPath = 0;
        for (Map.Entry<BlockPos, BlockState> set : blockPosMap.entrySet()) {
            CompatibilityBlockEqualsChecker.getInstance();
            if (!CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(set.getKey(), block, player.m_21206_(), player.m_9236_())) continue;
            ++existingPipesInPath;
        }
        return PipeConnectorUtils.getMissingPipesInInventory(player, NumberOfPipesInInventory, blockPosMap.size() - existingPipesInPath);
    }

    public static int getMissingPipesInInventory(Player player, int NumberOfPipesInInventory, Level level, HashSet<PreviewInfo> previewMap, Block block) {
        int existingPipesInPath = 0;
        for (PreviewInfo previewInfo : previewMap) {
            CompatibilityBlockEqualsChecker.getInstance();
            if (!CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(previewInfo.pos, block, player.m_21206_(), level)) continue;
            ++existingPipesInPath;
        }
        return PipeConnectorUtils.getMissingPipesInInventory(player, NumberOfPipesInInventory, previewMap.size() - existingPipesInPath);
    }

    public static HashSet<PreviewInfo> getBlockPosSet(Map<BlockPos, BlockState> blockPosMap) {
        HashSet<PreviewInfo> previewSet = new HashSet<PreviewInfo>();
        for (Map.Entry<BlockPos, BlockState> blockPair : blockPosMap.entrySet()) {
            previewSet.add(new PreviewInfo(blockPair.getKey()));
        }
        return previewSet;
    }

    public static Map<BlockPos, BlockState> getBlockPosMap(BlockPos start, BlockPos end, int depth, Level level, BridgeType bridgeType, Block placedBlock, ItemStack placedItemStack, boolean utilizeExistingPipes, Player player) {
        Map<BlockPos, BlockState> blockHashMap = new HashMap<BlockPos, BlockState>();
        int deltaY = Math.abs(start.m_123342_() - end.m_123342_());
        int startDepth = depth;
        int endDepth = depth;
        if (start.m_123342_() > end.m_123342_()) {
            endDepth -= deltaY;
        } else {
            startDepth -= deltaY;
        }
        if (bridgeType == BridgeType.DEFAULT) {
            start = PipeConnectorUtils.moveAndStoreStates(start, startDepth, 0, -1, 0, level, blockHashMap);
            end = PipeConnectorUtils.moveAndStoreStates(end, endDepth, 0, -1, 0, level, blockHashMap);
        } else {
            PathfindingResult result = PipeConnectorUtils.moveAndStoreStates(start, startDepth, level, blockHashMap, bridgeType, placedBlock, placedItemStack, utilizeExistingPipes, player);
            blockHashMap = result.blockPosMap;
            start = result.finalPosition;
            result = PipeConnectorUtils.moveAndStoreStates(end, endDepth, level, blockHashMap, bridgeType, placedBlock, placedItemStack, utilizeExistingPipes, player);
            blockHashMap = result.blockPosMap;
            end = result.finalPosition;
        }
        List<BlockPos> blockPosPath = null;
        switch (bridgeType) {
            case A_STAR: {
                blockPosPath = PathfindingAStarAlgorithm.findPathAStar(start, end, -1, level, player, new PathfindingAStarAlgorithm.PositionHeuristicChecker(utilizeExistingPipes, placedBlock, placedItemStack, level));
                break;
            }
            case DEFAULT: {
                blockPosPath = ManhattanAlgorithm.findPathManhattan(start, end, level);
            }
        }
        if (blockPosPath == null) {
            return blockHashMap;
        }
        for (BlockPos pos : blockPosPath) {
            blockHashMap.putIfAbsent(pos, level.m_8055_(pos));
        }
        return blockHashMap;
    }

    private static BlockPos moveAndStoreStates(BlockPos start, int steps, int xDirection, int yDirection, int zDirection, Level level, Map<BlockPos, BlockState> map) {
        BlockPos currentPos = start;
        for (int i = 0; i < steps; ++i) {
            map.putIfAbsent(currentPos, level.m_8055_(currentPos));
            currentPos = currentPos.m_7918_(xDirection, yDirection, zDirection);
        }
        return currentPos;
    }

    private static PathfindingResult moveAndStoreStates(BlockPos start, int steps, Level level, Map<BlockPos, BlockState> map, BridgeType bridgeType, Block placedBlock, ItemStack placedItemStack, boolean utilizeExistingPipes, Player player) {
        List<BlockPos> blockPosPath = null;
        BlockPos end = start.m_6625_(steps);
        switch (bridgeType) {
            case A_STAR: {
                blockPosPath = PathfindingAStarAlgorithm.findPathAStar(start, null, end.m_123342_(), level, player, new PathfindingAStarAlgorithm.DepthHeuristicChecker(utilizeExistingPipes, placedBlock, placedItemStack, level));
            }
        }
        if (blockPosPath == null) {
            return new PathfindingResult(map, start, start.m_6625_(steps));
        }
        for (BlockPos pos : blockPosPath) {
            map.putIfAbsent(pos, level.m_8055_(pos));
        }
        return new PathfindingResult(map, (BlockPos)blockPosPath.get(0), blockPosPath.get(blockPosPath.size() - 1));
    }

    public static BlockPos moveAndStoreStates(BlockPos start, int steps, int xDirection, int yDirection, int zDirection, Level level, Set<BlockPos> set) {
        BlockPos currentPos = start;
        for (int i = 0; i < steps; ++i) {
            set.add(currentPos);
            currentPos = currentPos.m_7918_(xDirection, yDirection, zDirection);
        }
        return currentPos;
    }

    private static boolean breakAndSetBlock(Level level, BlockPos pos, Block block, Player player, UseOnContext context) {
        if (CompatibilityPlacer.getInstance().place(level, pos, player, player.m_21206_())) {
            PipeConnectorUtils.handleBlockUpdates(level, pos);
            BlockEvent.EntityPlaceEvent event = PipeConnectorUtils.handlePlaceEvent(level, pos, level.m_8055_(pos), player);
            return !event.isCanceled();
        }
        return false;
    }

    private static void handleBlockUpdates(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            neighborState.m_60701_((LevelAccessor)level, neighborPos, 3);
        }
    }

    private static BlockEvent.EntityPlaceEvent handlePlaceEvent(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)pos), blockState, (Entity)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static int getNumberOfPipesInInventory(Player player) {
        Item pipe = player.m_21206_().m_41720_();
        int numberOfPipes = player.m_21206_().m_41613_();
        Inventory inventory = player.m_150109_();
        for (ItemStack itemStack : inventory.f_35974_) {
            if (itemStack.m_41720_() != pipe) continue;
            numberOfPipes += itemStack.m_41613_();
        }
        return numberOfPipes;
    }

    public static void reduceNumberOfPipesInInventory(Player player) {
        Item pipe = player.m_21206_().m_41720_();
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            if (((ItemStack)inventory.f_35974_.get(i)).m_41720_() != pipe) continue;
            if (((ItemStack)inventory.f_35974_.get(i)).m_41613_() > 1) {
                ((ItemStack)inventory.f_35974_.get(i)).m_41774_(1);
            } else {
                inventory.f_35974_.set(i, (Object)ItemStack.f_41583_);
            }
            return;
        }
        if (player.m_21206_().m_41613_() > 1) {
            player.m_21206_().m_41774_(1);
        } else {
            player.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        }
    }

    public static boolean connectBlocks(Player player, BlockPos startPos, Direction startDirection, BlockPos endPos, Direction endDirection, int depth, UseOnContext context, BridgeType bridgeType, boolean utilizeExistingPipes) {
        BlockPos relativeStartPos = startPos;
        BlockPos relativeEndPos = endPos;
        if (startDirection != null) {
            relativeStartPos = startPos.m_121945_(startDirection);
        }
        if (endDirection != null) {
            relativeEndPos = endPos.m_121945_(endDirection);
        }
        return PipeConnectorUtils.connectPathWithSegments(player, relativeStartPos, relativeEndPos, depth, context, bridgeType, utilizeExistingPipes);
    }

    public static class PathfindingResult {
        BlockPos finalPosition;
        BlockPos startPosition;
        Map<BlockPos, BlockState> blockPosMap;

        public PathfindingResult(Map<BlockPos, BlockState> blockPosMap, BlockPos startPosition, BlockPos finalPosition) {
            this.startPosition = startPosition;
            this.finalPosition = finalPosition;
            this.blockPosMap = blockPosMap;
        }
    }
}

