/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.network;

import com.heaser.pipeconnector.utils.GeneralUtils;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class UpdateUtilizeExistingPipes {
    public boolean utilizeExistingPipes;

    public UpdateUtilizeExistingPipes(boolean ShouldUtilizeExistingPipes) {
        this.utilizeExistingPipes = ShouldUtilizeExistingPipes;
    }

    public UpdateUtilizeExistingPipes(FriendlyByteBuf buf) {
        this.utilizeExistingPipes = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.utilizeExistingPipes);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            if (!GeneralUtils.isHoldingPipeConnector((Player)sender)) {
                return;
            }
            ItemStack item = sender.m_21205_();
            CompoundTag tag = item.m_41698_("pipe_connector");
            tag.m_128379_("UtilizeExistingPipes", this.utilizeExistingPipes);
        });
        ctx.get().setPacketHandled(true);
    }
}

