/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.network;

import com.heaser.pipeconnector.utils.GeneralUtils;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class UpdateInventoryGuard {
    public boolean inventoryGuard;

    public UpdateInventoryGuard(boolean shouldInventoryGuard) {
        this.inventoryGuard = shouldInventoryGuard;
    }

    public UpdateInventoryGuard(FriendlyByteBuf buf) {
        this.inventoryGuard = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.inventoryGuard);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            if (!GeneralUtils.isHoldingPipeConnector((Player)sender)) {
                return;
            }
            ItemStack item = sender.m_21205_();
            CompoundTag tag = item.m_41698_("pipe_connector");
            tag.m_128379_("PreventInventoryBlockBreaking", this.inventoryGuard);
        });
        ctx.get().setPacketHandled(true);
    }
}

