/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.items;

import com.heaser.pipeconnector.client.proxy.GeneralClientProxy;
import com.heaser.pipeconnector.client.proxy.IClientProxy;
import com.heaser.pipeconnector.client.proxy.items.IPipeConnectorItemProxy;
import com.heaser.pipeconnector.client.proxy.items.PipeConnectorItemProxy;
import com.heaser.pipeconnector.compatibility.CompatibilityDirectionGetter;
import com.heaser.pipeconnector.particles.ParticleHelper;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.TagUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeConnectorItem
extends Item {
    private final IPipeConnectorItemProxy itemProxy = (IPipeConnectorItemProxy)DistExecutor.unsafeRunForDist(() -> PipeConnectorItemProxy::new, () -> () -> null);
    private final IClientProxy clientProxy = (IClientProxy)DistExecutor.unsafeRunForDist(() -> GeneralClientProxy::new, () -> () -> null);

    public PipeConnectorItem(Item.Properties properties) {
        super(properties);
    }

    public void m_142312_(CompoundTag tag) {
        TagUtils.setCustomModelData(tag, GeneralUtils.isAprilFoolsDay());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!level.m_5776_() || this.itemProxy == null) {
            return InteractionResultHolder.m_19098_((Object)heldItem);
        }
        HitResult targetHitResult = player.m_19907_(player.getBlockReach() - 1.0, 0.0f, false);
        Vec3 targetPosition = targetHitResult.m_82450_();
        BlockPos targetBlockPos = new BlockPos((int)targetPosition.f_82479_, (int)targetPosition.f_82480_, (int)targetPosition.f_82481_);
        boolean isTargetBlockAir = level.m_8055_(targetBlockPos).m_60795_();
        boolean isShiftKeyHeld = player.m_6144_();
        if (hand == InteractionHand.MAIN_HAND && isShiftKeyHeld && isTargetBlockAir) {
            this.itemProxy.openPipeConnectorGui(heldItem);
        }
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        ItemStack interactedItem = context.m_43722_();
        this.handleCommonUseOn(interactedItem);
        if (GeneralUtils.isServerSide(level)) {
            return this.handleServerSideUseOn(context);
        }
        return InteractionResult.FAIL;
    }

    private void handleCommonUseOn(ItemStack interactedItem) {
        int depth = TagUtils.getDepthFromStack(interactedItem);
        if (depth == -1) {
            TagUtils.setDepthToStack(interactedItem, 2);
        }
    }

    private InteractionResult handleServerSideUseOn(UseOnContext context) {
        Player usingPlayer = context.m_43723_();
        Level level = context.m_43725_();
        ItemStack interactedItem = context.m_43722_();
        BlockPos clickedPosition = context.m_8083_();
        Direction clickedFace = CompatibilityDirectionGetter.getInstance().getDirection(context);
        if (usingPlayer == null) {
            return InteractionResult.FAIL;
        }
        boolean isShiftKeyDown = usingPlayer.m_6144_();
        BlockPos relativePosition = clickedPosition;
        if (clickedFace != null) {
            relativePosition = clickedPosition.m_121945_(clickedFace);
        }
        if (isShiftKeyDown) {
            if (!GeneralUtils.isPlaceableBlock(usingPlayer)) {
                usingPlayer.m_5661_((Component)Component.m_237115_((String)"item.pipe_connector.message.holdValidItem").m_130940_(ChatFormatting.GOLD), true);
                return InteractionResult.FAIL;
            }
            if (clickedFace == Direction.UP) {
                usingPlayer.m_5661_((Component)Component.m_237115_((String)"item.pipe_connector.message.UpSideNotAllowed").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}), true);
                return InteractionResult.FAIL;
            }
            BlockPos startPos = TagUtils.getStartPosition(interactedItem);
            Direction startDirection = TagUtils.getStartDirection(interactedItem);
            if (startPos == null) {
                TagUtils.setStartPositionAndDirection(interactedItem, clickedFace, clickedPosition);
                TagUtils.setDimension(interactedItem, level.m_220362_().toString());
                ParticleHelper.serverSpawnMarkerParticle((ServerLevel)level, relativePosition);
            } else {
                if (!level.m_220362_().toString().equals(TagUtils.getDimension(interactedItem))) {
                    TagUtils.resetPositionAndDirectionTags(interactedItem, usingPlayer, false);
                    return InteractionResult.FAIL;
                }
                if (clickedPosition.equals((Object)startPos) && clickedFace == startDirection) {
                    TagUtils.resetPositionAndDirectionTags(interactedItem, usingPlayer, true);
                    return InteractionResult.FAIL;
                }
                TagUtils.setEndPositionAndDirection(interactedItem, clickedFace, clickedPosition);
                ParticleHelper.serverSpawnMarkerParticle((ServerLevel)level, relativePosition);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        if (this.clientProxy != null) {
            if (this.clientProxy.hasShiftDown()) {
                components.add((Component)Component.m_237115_((String)"item.pipe_connector.tooltip.usageExplanation").m_130940_(ChatFormatting.DARK_AQUA));
                components.add((Component)Component.m_237115_((String)"item.pipe_connector.tooltip.openGui").m_130940_(ChatFormatting.BLUE));
                components.add((Component)Component.m_237115_((String)"item.pipe_connector.tooltip.changeDepthExplanation").m_130940_(ChatFormatting.LIGHT_PURPLE));
            } else {
                components.add((Component)Component.m_237115_((String)"item.pipe_connector.tooltip.shiftForMoreInfo").m_130940_(ChatFormatting.GOLD));
            }
        }
        super.m_7373_(stack, level, components, tooltipFlag);
    }
}

