/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility;

import com.heaser.pipeconnector.compatibility.ae2.AE2Compatiblity;
import com.heaser.pipeconnector.compatibility.interfaces.IBlockGetter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;

public class CompatibilityBlockGetter {
    private static CompatibilityBlockGetter INSTANCE;
    private final HashMap<Class<? extends Item>, IBlockGetter> classToGetterMap = new HashMap();

    private CompatibilityBlockGetter() {
        if (this.isModLoaded("ae2")) {
            this.classToGetterMap.put(AE2Compatiblity.getItemStackClassToRegister(), new AE2Compatiblity());
        }
    }

    private boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static CompatibilityBlockGetter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CompatibilityBlockGetter();
        }
        return INSTANCE;
    }

    public Block defaultGetBlock(ItemStack placedStack) {
        return Block.m_49814_((Item)placedStack.m_41720_());
    }

    public Block getBlock(ItemStack placedStack) {
        IBlockGetter getter = null;
        for (Map.Entry<Class<? extends Item>, IBlockGetter> set : this.classToGetterMap.entrySet()) {
            if (!set.getKey().isAssignableFrom(placedStack.m_41720_().getClass())) continue;
            getter = set.getValue();
            break;
        }
        if (getter != null) {
            return getter.getBlock(placedStack);
        }
        return this.defaultGetBlock(placedStack);
    }
}

