/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.outline;

import com.heaser.pipeconnector.client.outline.PipeConnectorRenderType;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockEqualsChecker;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockGetter;
import com.heaser.pipeconnector.utils.BuildParameters;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.PipeConnectorUtils;
import com.heaser.pipeconnector.utils.PreviewInfo;
import com.heaser.pipeconnector.utils.TagUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PreviewDrawer {
    public HashSet<PreviewInfo> previewMap = new HashSet();
    private BuildParameters cachedParameters = new BuildParameters();

    public void handleOnRenderLevel(PoseStack pose, MultiBufferSource buffer, Player player) {
        ItemStack heldItem = GeneralUtils.heldPipeConnector(player);
        if (heldItem == null) {
            return;
        }
        if (this.shouldUpdatePreview(heldItem)) {
            Level currentLevel = player.m_9236_();
            this.previewMap = this.getNewPreview(heldItem, currentLevel, player);
        }
        this.draw(pose, buffer, player, heldItem);
    }

    private HashSet<PreviewInfo> getNewPreview(ItemStack pipeConnector, Level currentLevel, Player player) {
        BlockPos startPos = TagUtils.getStartPosition(pipeConnector);
        BlockPos endPos = TagUtils.getEndPosition(pipeConnector);
        if (startPos == null || endPos == null) {
            return new HashSet<PreviewInfo>();
        }
        int depth = TagUtils.getDepthFromStack(pipeConnector);
        boolean utilizeExitingPipes = TagUtils.getUtilizeExistingPipes(pipeConnector);
        Direction startDirection = TagUtils.getStartDirection(pipeConnector);
        Direction endDirection = TagUtils.getEndDirection(pipeConnector);
        BlockPos relativeStartPos = startPos;
        BlockPos relativeEndPos = endPos;
        if (startDirection != null) {
            relativeStartPos = startPos.m_121945_(startDirection);
        }
        if (endDirection != null) {
            relativeEndPos = endPos.m_121945_(endDirection);
        }
        return PipeConnectorUtils.getBlockPosSet(PipeConnectorUtils.getBlockPosMap(relativeStartPos, relativeEndPos, depth, currentLevel, TagUtils.getBridgeType(pipeConnector), CompatibilityBlockGetter.getInstance().getBlock(player.m_21206_()), player.m_21206_(), utilizeExitingPipes, player));
    }

    private void draw(PoseStack pose, MultiBufferSource buffer, Player player, ItemStack pipeConnector) {
        VertexConsumer builder = buffer.m_6299_(PipeConnectorRenderType.LINES_NO_DEPTH_TEST);
        Vec3 offset = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        for (PreviewInfo previewInfo : this.previewMap) {
            AABB aabb = new AABB(previewInfo.pos).m_82386_(-offset.f_82479_, -offset.f_82480_, -offset.f_82481_);
            if (previewInfo.isRelativeStartPos(pipeConnector)) {
                LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)0.5f, (float)0.7f, (float)0.9f, (float)1.0f);
                continue;
            }
            if (previewInfo.isRelativeEndPos(pipeConnector)) {
                LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)1.0f, (float)0.5f, (float)0.3f, (float)1.0f);
                continue;
            }
            if (GeneralUtils.isNotBreakable(player.m_9236_(), previewInfo.pos) || GeneralUtils.hasInventoryCapabilities(player.m_9236_(), previewInfo.pos)) {
                LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                continue;
            }
            if (GeneralUtils.isVoidableBlock(player.m_9236_(), previewInfo.pos)) {
                LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                continue;
            }
            CompatibilityBlockEqualsChecker.getInstance();
            if (CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(previewInfo.pos, CompatibilityBlockGetter.getInstance().getBlock(player.m_21206_()), player.m_21206_(), player.m_9236_())) {
                LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)0.87f, (float)0.25f, (float)0.87f, (float)0.5f);
                continue;
            }
            LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
        }
    }

    private boolean shouldUpdatePreview(ItemStack pipeConnector) {
        boolean shouldUpdate = false;
        BuildParameters newParameters = new BuildParameters(pipeConnector);
        if (!this.cachedParameters.equals(newParameters)) {
            shouldUpdate = true;
            this.cachedParameters = newParameters;
        }
        return shouldUpdate;
    }
}

