/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.gui.buttons;

import com.heaser.pipeconnector.client.gui.buttons.BaseButton;
import com.heaser.pipeconnector.network.NetworkHandler;
import com.heaser.pipeconnector.network.UpdateInventoryGuard;
import com.heaser.pipeconnector.utils.TagUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class InventoryGuardButton
extends BaseButton {
    public InventoryGuardButton(ItemStack itemStack) {
        super(InventoryGuardButton.getInitialLabel(itemStack), 20, 20);
    }

    @Override
    public void onClick(Button clickedButton, ItemStack itemStack) {
        if (TagUtils.getPreventInventoryBlockBreaking(itemStack)) {
            this.setLabel("item.pipe_connector.gui.button.off", ChatFormatting.RED);
            this.button.m_93666_(this.getLabel());
            TagUtils.setPreventInventoryBlockBreaking(itemStack, false);
        } else {
            this.setLabel("item.pipe_connector.gui.button.on", ChatFormatting.GREEN);
            this.button.m_93666_(this.getLabel());
            TagUtils.setPreventInventoryBlockBreaking(itemStack, true);
        }
        NetworkHandler.CHANNEL.sendToServer((Object)new UpdateInventoryGuard(TagUtils.getPreventInventoryBlockBreaking(itemStack)));
    }

    @Override
    public Component getTooltip(ItemStack itemStack) {
        return Component.m_237115_((String)"item.pipe_connector.gui.button.tooltip.InventoryGuard");
    }

    private static Component getInitialLabel(ItemStack itemStack) {
        if (TagUtils.getPreventInventoryBlockBreaking(itemStack)) {
            return Component.m_237115_((String)"item.pipe_connector.gui.button.on").m_130940_(ChatFormatting.GREEN);
        }
        return Component.m_237115_((String)"item.pipe_connector.gui.button.off").m_130940_(ChatFormatting.RED);
    }
}

