/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.gui.buttons;

import com.heaser.pipeconnector.client.ClientSetup;
import com.heaser.pipeconnector.client.gui.buttons.BaseButton;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockGetter;
import com.heaser.pipeconnector.config.PipeConnectorConfig;
import com.heaser.pipeconnector.network.BuildPipesPacket;
import com.heaser.pipeconnector.network.NetworkHandler;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.PipeConnectorUtils;
import com.heaser.pipeconnector.utils.TagUtils;
import java.util.Optional;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BuildPipesButton
extends BaseButton {
    private final LocalPlayer player;

    public BuildPipesButton(LocalPlayer player) {
        super((Component)Component.m_237115_((String)"item.pipe_connector.gui.button.PlacePipes"), 20, 80);
        this.player = player;
    }

    @Override
    public void onClick(Button clickedButton, ItemStack itemStack) {
        NetworkHandler.CHANNEL.sendToServer((Object)new BuildPipesPacket());
    }

    @Override
    public boolean shouldClose() {
        return true;
    }

    @Override
    public boolean isActive(ItemStack itemStack) {
        return this.getErrorMessage(itemStack) == null;
    }

    @Override
    public Component getTooltip(ItemStack itemStack) {
        return this.getErrorMessage(itemStack);
    }

    private Component getErrorMessage(ItemStack itemStack) {
        BlockPos blockPos = TagUtils.getEndPosition(itemStack);
        int existingPipes = PipeConnectorUtils.getNumberOfPipesInInventory((Player)this.player);
        int missingPipes = PipeConnectorUtils.getMissingPipesInInventory((Player)this.player, existingPipes, this.player.m_9236_(), ClientSetup.PREVIEW_DRAWER.previewMap, CompatibilityBlockGetter.getInstance().getBlock(this.player.m_21206_()));
        int maxAllowedPipes = (Integer)PipeConnectorConfig.MAX_ALLOWED_PIPES_TO_PLACE.get();
        Optional<BlockPos> inventoryBlockPos = this.pathContainsInventory();
        Optional<BlockPos> unbreakableBlockPos = this.pathContainsUnbreakableBlocks();
        if (blockPos == null) {
            return Component.m_237115_((String)"item.pipe_connector.gui.button.tooltip.disabledPlacePipes");
        }
        if (!GeneralUtils.isPlaceableBlock((Player)this.player)) {
            return Component.m_237115_((String)"item.pipe_connector.gui.button.tooltip.disabledButtonHoldValidItem");
        }
        if (inventoryBlockPos.isPresent() && TagUtils.getPreventInventoryBlockBreaking(itemStack)) {
            String blockName = this.player.m_9236_().m_8055_(inventoryBlockPos.get()).m_60734_().m_49954_().getString();
            return Component.m_237110_((String)"item.pipe_connector.gui.button.tooltip.disabledInventoryInPath", (Object[])new Object[]{blockName});
        }
        if (unbreakableBlockPos.isPresent()) {
            String blockName = this.player.m_9236_().m_8055_(unbreakableBlockPos.get()).m_60734_().m_49954_().getString();
            return Component.m_237110_((String)"item.pipe_connector.message.unbreakableBlockReached", (Object[])new Object[]{blockName});
        }
        if (ClientSetup.PREVIEW_DRAWER.previewMap.size() >= maxAllowedPipes) {
            return Component.m_237110_((String)"item.pipe_connector.gui.button.toolTip.maxAllowedPipesReached", (Object[])new Object[]{maxAllowedPipes});
        }
        if (missingPipes > 0) {
            return Component.m_237110_((String)"item.pipe_connector.gui.button.tooltip.disabledNotEnoughPipes", (Object[])new Object[]{missingPipes});
        }
        return null;
    }

    private Optional<BlockPos> pathContainsInventory() {
        return ClientSetup.PREVIEW_DRAWER.previewMap.stream().filter(block -> GeneralUtils.hasInventoryCapabilities(this.player.m_9236_(), block.pos)).map(block -> block.pos).findFirst();
    }

    private Optional<BlockPos> pathContainsUnbreakableBlocks() {
        return ClientSetup.PREVIEW_DRAWER.previewMap.stream().filter(block -> GeneralUtils.isNotBreakable(this.player.m_9236_(), block.pos)).map(block -> block.pos).findFirst();
    }
}

