/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.gui;

import com.heaser.pipeconnector.client.gui.buttons.BaseButton;
import com.heaser.pipeconnector.client.gui.buttons.BridgeTypeButton;
import com.heaser.pipeconnector.client.gui.buttons.BuildPipesButton;
import com.heaser.pipeconnector.client.gui.buttons.InventoryGuardButton;
import com.heaser.pipeconnector.client.gui.buttons.ResetButton;
import com.heaser.pipeconnector.client.gui.buttons.UtilizeExistingPipesButton;
import com.heaser.pipeconnector.client.gui.interfaces.ILabelable;
import com.heaser.pipeconnector.client.gui.labels.DepthLabel;
import com.heaser.pipeconnector.client.gui.labels.InventoryGuardText;
import com.heaser.pipeconnector.client.gui.labels.TitleLabelText;
import com.heaser.pipeconnector.client.gui.labels.UtilizeExistingPipesText;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PipeConnectorGui
extends Screen {
    public static final ResourceLocation PIPE_CONNECTOR_TEXTURE = new ResourceLocation("pipe_connector", "textures/gui/settings.png");
    protected static final Integer imageWidth = 256;
    protected static final Integer imageHeight = 256;
    private ItemStack pipeConnectorStack;
    private BaseButton resetBaseButton;
    private BaseButton buildPipesButton;
    private BaseButton bridgeTypeButton;
    private BaseButton utilizeExistingPipesButton;
    private BaseButton inventoryGuardButton;

    public PipeConnectorGui(ItemStack pipeConnectorStack) {
        super((Component)Component.m_237113_((String)"PipeConnectorScreen"));
        this.pipeConnectorStack = pipeConnectorStack;
    }

    protected void m_7856_() {
        this.bridgeTypeButton = this.createButton(0.05, 0.2, new BridgeTypeButton(this.pipeConnectorStack));
        this.inventoryGuardButton = this.createButton(0.45, 0.3, new InventoryGuardButton(this.pipeConnectorStack));
        this.utilizeExistingPipesButton = this.createButton(0.45, 0.4, new UtilizeExistingPipesButton(this.pipeConnectorStack));
        this.resetBaseButton = this.createButton(0.65, 0.7, new ResetButton());
        this.buildPipesButton = this.createButton(0.65, 0.8, new BuildPipesButton(this.getMinecraft().f_91074_));
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.getMinecraft().f_91074_ != null && GeneralUtils.isHoldingPipeConnector((Player)this.getMinecraft().f_91074_)) {
            this.pipeConnectorStack = this.getMinecraft().f_91074_.m_21205_();
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PIPE_CONNECTOR_TEXTURE);
        int drawStartX = this.getScreenX();
        int drawStartY = this.getScreenY();
        this.drawTooltip(guiGraphics, mouseX, mouseY, this.resetBaseButton);
        this.drawTooltip(guiGraphics, mouseX, mouseY, this.buildPipesButton);
        this.drawTooltipList(guiGraphics, mouseX, mouseY, this.bridgeTypeButton);
        this.drawTooltip(guiGraphics, mouseX, mouseY, this.inventoryGuardButton);
        this.drawTooltipList(guiGraphics, mouseX, mouseY, this.utilizeExistingPipesButton);
        guiGraphics.m_280218_(PIPE_CONNECTOR_TEXTURE, drawStartX, drawStartY, 0, 0, imageWidth.intValue(), imageHeight.intValue());
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.utilizeExistingPipesButton.button.f_93623_ = this.utilizeExistingPipesButton.isActive(this.pipeConnectorStack);
        this.buildPipesButton.button.f_93623_ = this.buildPipesButton.isActive(this.pipeConnectorStack);
        this.createLabel(guiGraphics, 0.07, 0.05, new TitleLabelText(), 3.0f);
        this.createLabel(guiGraphics, 0.12, 0.32, new InventoryGuardText());
        this.createLabel(guiGraphics, 0.08, 0.42, new UtilizeExistingPipesText());
        this.createLabel(guiGraphics, 0.65, 0.65, new DepthLabel());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.m_6913_() || keyCode == 69) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private BaseButton createButton(double marginXPercent, double marginYPercent, BaseButton baseButton) {
        int marginX = (int)((double)imageWidth.intValue() * marginXPercent);
        int marginY = (int)((double)imageHeight.intValue() * marginYPercent);
        int drawStartX = this.getScreenX() + marginX;
        int drawStartY = this.getScreenY() + marginY;
        Button button = Button.m_253074_((Component)baseButton.label, clickedButton -> this.onButtonClick(clickedButton, baseButton)).m_252794_(drawStartX, drawStartY).m_253046_(baseButton.getButtonWidth(), baseButton.getButtonHeight()).m_253136_();
        button.f_93623_ = baseButton.isActive(this.pipeConnectorStack);
        baseButton.bindButton(button);
        this.m_142416_((GuiEventListener)button);
        return baseButton;
    }

    private void createLabel(GuiGraphics guiGraphics, double marginXPercent, double marginYPercent, ILabelable label) {
        int marginX = (int)((double)imageWidth.intValue() * marginXPercent);
        int marginY = (int)((double)imageHeight.intValue() * marginYPercent);
        int drawStartX = this.getScreenX() + marginX;
        int drawStartY = this.getScreenY() + marginY;
        guiGraphics.m_280614_(this.f_96547_, label.getLabel(this.pipeConnectorStack), drawStartX, drawStartY, 0, false);
    }

    private void createLabel(GuiGraphics guiGraphics, double marginXPercent, double marginYPercent, ILabelable label, float scale) {
        int marginX = (int)((double)imageWidth.intValue() * marginXPercent);
        int marginY = (int)((double)imageHeight.intValue() * marginYPercent);
        int drawStartX = (this.getScreenX() + marginX) / (int)scale;
        int drawStartY = (this.getScreenY() + marginY) / (int)scale;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280614_(this.f_96547_, label.getLabel(this.pipeConnectorStack), drawStartX, drawStartY, 0, false);
        guiGraphics.m_280168_().m_85849_();
    }

    private void drawTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, BaseButton baseButton) {
        Component tooltipText = baseButton.getTooltip(this.pipeConnectorStack);
        if (tooltipText != null && baseButton.button.m_274382_()) {
            guiGraphics.m_280557_(this.f_96547_, tooltipText, mouseX, mouseY);
        }
    }

    private void drawTooltipList(GuiGraphics guiGraphics, int mouseX, int mouseY, BaseButton baseButton) {
        List<Component> tooltipTextList = baseButton.getTooltipList(this.pipeConnectorStack);
        if (tooltipTextList != null && baseButton.button.m_274382_()) {
            guiGraphics.m_280677_(this.f_96547_, tooltipTextList, Optional.empty(), mouseX, mouseY);
        }
    }

    private void onButtonClick(Button clickedButton, BaseButton baseButton) {
        baseButton.onClick(clickedButton, this.pipeConnectorStack);
        if (baseButton.shouldClose()) {
            this.m_7379_();
        }
    }

    private int getScreenX() {
        return (this.f_96543_ - imageWidth) / 2;
    }

    private int getScreenY() {
        return (this.f_96544_ - imageHeight) / 2;
    }

    public boolean m_7043_() {
        return false;
    }
}

