/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.sandbox;

import com.mojang.serialization.Lifecycle;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.provider.RegistryProviderBase;
import org.moddingx.libx.sandbox.SandBox;
import org.moddingx.libx.sandbox.surface.BiomeSurface;
import org.moddingx.libx.sandbox.surface.SurfaceRuleSet;

public abstract class SurfaceProviderBase
extends RegistryProviderBase {
    protected SurfaceProviderBase(DatagenContext ctx) {
        super(ctx, DatagenStage.EXTENSION_SETUP);
    }

    @Override
    public final String getName() {
        return this.mod.modid + " surface rules";
    }

    public RuleSetBuilder ruleSet() {
        return this.ruleSet(false);
    }

    public RuleSetBuilder ruleSet(boolean defaultNoiseSurface) {
        return new RuleSetBuilder(defaultNoiseSurface);
    }

    public Holder<BiomeSurface> biome(Holder<Biome> biome, SurfaceRules.RuleSource ... rules) {
        ResourceKey key = (ResourceKey)biome.m_203543_().orElseThrow(() -> new IllegalStateException("Can't make biome surface: unbound biome holder: " + biome));
        return this.biome((ResourceKey<Biome>)key, rules);
    }

    public Holder<BiomeSurface> biome(ResourceKey<Biome> biome, SurfaceRules.RuleSource ... rules) {
        BiomeSurface surface = new BiomeSurface(SurfaceProviderBase.of(rules));
        return this.registries.writableRegistry(SandBox.BIOME_SURFACE).m_255290_(ResourceKey.m_135785_(SandBox.BIOME_SURFACE, (ResourceLocation)biome.m_135782_()), (Object)surface, Lifecycle.stable());
    }

    private static SurfaceRules.RuleSource of(SurfaceRules.RuleSource[] rules) {
        if (rules.length == 0) {
            return SandBox.emptySurface();
        }
        if (rules.length == 1) {
            return rules[0];
        }
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])rules);
    }

    public class RuleSetBuilder {
        private final boolean defaultNoiseSurface;
        private SurfaceRules.RuleSource beforeBiomes;
        private SurfaceRules.RuleSource afterBiomes;
        private SurfaceRules.RuleSource defaultBiomeSurface;

        private RuleSetBuilder(boolean defaultNoiseSurface) {
            this.defaultNoiseSurface = defaultNoiseSurface;
            this.beforeBiomes = SandBox.emptySurface();
            this.afterBiomes = SandBox.emptySurface();
            this.defaultBiomeSurface = SandBox.emptySurface();
        }

        public RuleSetBuilder beforeBiomes(SurfaceRules.RuleSource ... rules) {
            this.beforeBiomes = SurfaceProviderBase.of(rules);
            return this;
        }

        public RuleSetBuilder afterBiomes(SurfaceRules.RuleSource ... rules) {
            this.afterBiomes = SurfaceProviderBase.of(rules);
            return this;
        }

        public RuleSetBuilder defaultBiomeSurface(SurfaceRules.RuleSource ... rules) {
            this.defaultBiomeSurface = SurfaceProviderBase.of(rules);
            return this;
        }

        public Holder<SurfaceRuleSet> build() {
            return SurfaceProviderBase.this.registries.writableRegistry(SandBox.SURFACE_RULE_SET).m_203693_((Object)new SurfaceRuleSet(this.defaultNoiseSurface, this.beforeBiomes, this.afterBiomes, this.defaultBiomeSurface));
        }
    }
}

