/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.moddingx.libx.datagen.DatagenSystem;
import org.moddingx.libx.datagen.RegistrySet;
import org.moddingx.libx.impl.datagen.registries.DatagenRegistrySet;
import org.moddingx.libx.impl.datagen.resource.ResourceLocator;

public class PackTarget {
    private final String name;
    private final DatagenSystem system;
    private final DatagenRegistrySet registries;
    private final Map<PackType, Path> outputMap;
    private final Map<PackType, ResourceLocator> resourceMap;
    private final PackOutput packOutput;

    PackTarget(String name, DatagenSystem system, RegistrySet registries, Map<PackType, Path> outputMap, Map<PackType, String> prefixMap, Map<PackType, List<Path>> resourcePathMap, List<PackTarget> parents) {
        boolean rootResources;
        this.name = name;
        this.system = system;
        if (!(registries instanceof DatagenRegistrySet)) {
            throw new IllegalArgumentException("Custom RegistrySet instances are not supported.");
        }
        DatagenRegistrySet drs = (DatagenRegistrySet)registries;
        if (drs.isRoot()) {
            throw new IllegalArgumentException("Can't create pack target with root registry set");
        }
        this.registries = drs;
        this.outputMap = Map.copyOf(outputMap);
        boolean bl = rootResources = prefixMap == null && resourcePathMap == null && parents == null;
        if (!rootResources) {
            Objects.requireNonNull(prefixMap);
            Objects.requireNonNull(resourcePathMap);
            Objects.requireNonNull(parents);
        }
        this.resourceMap = this.outputMap.keySet().stream().map(type -> {
            if (rootResources) {
                return Map.entry(type, ResourceLocator.root(type));
            }
            List<ResourceLocator> parentLocators = parents.stream().flatMap(p -> Stream.ofNullable(p.resourceMap.getOrDefault(type, null))).toList();
            ResourceLocator locator = new ResourceLocator(List.copyOf(resourcePathMap.getOrDefault(type, List.of())), prefixMap.getOrDefault(type, null), parentLocators);
            return Map.entry(type, locator);
        }).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        this.packOutput = new Vanilla();
    }

    public String name() {
        return this.name;
    }

    public DatagenSystem system() {
        return this.system;
    }

    public RegistrySet registries() {
        return this.registries;
    }

    public Map<PackType, Path> outputMap() {
        return this.outputMap;
    }

    public Path path(PackType type) {
        if (this.outputMap.containsKey(type)) {
            return this.outputMap.get(type);
        }
        throw new UnsupportedOperationException("The pack target '" + this.name + "' does not support output on " + type);
    }

    public Resource find(PackType type, ResourceLocation resourceId) throws FileNotFoundException {
        if (!this.resourceMap.containsKey(type)) {
            throw new UnsupportedOperationException("The pack target '" + this.name + "' does not support output on " + type);
        }
        Resource resource = this.resourceMap.get(type).getResource(this.system.fileHelper(), resourceId);
        if (resource == null) {
            throw new FileNotFoundException(this.name + "/" + resourceId);
        }
        return resource;
    }

    public PackOutput packOutput() {
        return this.packOutput;
    }

    private class Vanilla
    extends PackOutput {
        public Vanilla() {
            super(PackTarget.this.system.mainOutput());
        }

        @Nonnull
        public Path m_245114_() {
            throw new UnsupportedOperationException("Can't get root output folder for this pack type");
        }

        @Nonnull
        public Path m_247566_(@Nonnull PackOutput.Target target) {
            return switch (target) {
                default -> throw new IncompatibleClassChangeError();
                case PackOutput.Target.RESOURCE_PACK -> PackTarget.this.path(PackType.CLIENT_RESOURCES);
                case PackOutput.Target.DATA_PACK -> PackTarget.this.path(PackType.SERVER_DATA);
                case PackOutput.Target.REPORTS -> PackTarget.this.system.mainOutput().resolve("reports");
            };
        }
    }

    public static interface Resource {
        public InputStream open() throws IOException;

        public BufferedReader read() throws IOException;

        public ResourceMetadata meta() throws IOException;
    }
}

