/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.compat.pneumaticcraft;

import chiefarug.mods.systeams.Systeams;
import chiefarug.mods.systeams.SysteamsConfig;
import chiefarug.mods.systeams.block_entities.BoilerBlockEntityBase;
import chiefarug.mods.systeams.compat.pneumaticcraft.PneumaticBoilerMenu;
import chiefarug.mods.systeams.compat.pneumaticcraft.SysteamsPNCRCompat;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.lib.util.managers.IFuelManager;
import java.util.Map;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PneumaticBoilerBlockEntity
extends BoilerBlockEntityBase
implements ITickableTile.IClientTickable {
    private static final int airPerCycle = 100;
    private static final int energyPerCycle = 40;
    protected final IAirHandlerMachine airHandler;
    private final LazyOptional<IAirHandlerMachine> airHandlerCap;
    private int airPerTick = this.calcAirPerTick();

    public PneumaticBoilerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)SysteamsPNCRCompat.Registry.PNEUMATIC_BOILER_BLOCK_ENTITY.get(), pos, blockState);
        this.airHandler = PneumaticRegistry.getInstance().getAirHandlerMachineFactory().createAirHandler(PressureTier.TIER_TWO, 10000);
        this.airHandlerCap = LazyOptional.of(() -> this.airHandler);
        this.addAugmentSlots(ThermalCoreConfig.dynamoAugments);
        this.initHandlers();
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("AirHandler", this.airHandler.serializeNBT());
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeFloat(this.airHandler.getPressure());
        return buffer;
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.airHandler.setPressure(buffer.readFloat());
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.airHandler.deserializeNBT((Tag)nbt.m_128469_("AirHandler"));
        if (nbt.m_128441_("AirAmount")) {
            this.airHandler.addAir(nbt.m_128451_("AirAmount"));
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.airHandler.tick((BlockEntity)this);
    }

    @Override
    protected int consumeFuel() {
        this.addAir(-100);
        return 40;
    }

    @Override
    protected int getFuelEnergy() {
        if (this.getPressure() > this.getMinWorkingPressure()) {
            return 40;
        }
        return 0;
    }

    @Override
    protected double getEnergyToSteamRatio() {
        return (Double)SysteamsConfig.STEAM_RATIO_PNEUMATIC.get();
    }

    @Override
    protected IFuelManager getFuelManager() {
        throw new NotImplementedException("There is no air fuel manager!");
    }

    @Override
    protected double getSpeedMultiplier() {
        return (Double)SysteamsConfig.SPEED_PNEUMATIC.get();
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.airPerTick = this.calcAirPerTick();
        float holdingMod = this.getHoldingMod(enchantmentMap);
        float baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        this.airHandler.setVolumeUpgrades((int)(holdingMod + baseMod - 2.0f));
    }

    private int calcAirPerTick() {
        return (int)((double)this.baseEnergyPerTick / 40.0 * 100.0);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInv, Player player) {
        assert (this.f_58857_ != null);
        return new PneumaticBoilerMenu(containerId, this.f_58857_, this.m_58899_(), playerInv, player);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == Systeams.AIR_HANDLER_CAPABILITY) {
            if (side == null || side != this.getFacing()) {
                return this.airHandlerCap.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public float getPressure() {
        return this.airHandler.getPressure();
    }

    public float getMinWorkingPressure() {
        return 15.0f;
    }

    public void addAir(int air) {
        this.airHandler.addAir(air);
    }

    public int getAirPerTick() {
        return this.airPerTick;
    }

    public int getAir() {
        return this.airHandler.getAir();
    }

    public int getVolume() {
        return this.airHandler.getVolume();
    }

    public void tickClient() {
        this.airHandler.tick((BlockEntity)this);
    }
}

