/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.block_entities;

import chiefarug.mods.systeams.SysteamsConfig;
import chiefarug.mods.systeams.SysteamsRegistry;
import chiefarug.mods.systeams.containers.SteamDynamoMenu;
import chiefarug.mods.systeams.recipe.SteamFuelManager;
import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.common.network.packet.client.TileStatePacket;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.common.fluid.FluidStorageCoFH;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.lib.common.block.entity.DynamoBlockEntity;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class SteamDynamoBlockEntity
extends DynamoBlockEntity {
    private final Predicate<FluidStack> isSteam = fluid -> this.filter.valid(fluid) && SteamFuelManager.instance().validFuel((FluidStack)fluid);
    protected final FluidStorageCoFH steamTank = new FluidStorageCoFH(16000, this.isSteam);
    private int fuelPerCycle = 1;

    public SteamDynamoBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SysteamsRegistry.BlockEntities.STEAM_DYNAMO.get(), pos, state);
        this.tankInv.addTank(this.steamTank, StorageGroup.INPUT);
        this.renderFluid = new FluidStack((Fluid)SysteamsRegistry.Fluids.STEAM.stillFluid.get(), 1000);
        this.addAugmentSlots(ThermalCoreConfig.dynamoAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return (int)Math.round((double)SteamFuelManager.instance().getBasePower() * (Double)SysteamsConfig.STEAM_DYNAMO_MULTIPLIER.get());
    }

    protected boolean canProcessStart() {
        return SteamFuelManager.instance().getEnergy(this.steamTank.getFluidStack()) > 0 && this.steamTank.getAmount() >= 100;
    }

    protected void processStart() {
        if (this.cacheRenderFluid()) {
            TileStatePacket.sendToClient((IPacketHandlerTile)this);
        }
        this.fuelUp();
    }

    private void fuelUp() {
        int energy = Math.round((float)SteamFuelManager.instance().getEnergy(this.steamTank.getFluidStack()) * this.energyMod);
        for (int i = this.fuelPerCycle; i > 0 && !this.steamTank.isEmpty(); --i) {
            this.fuel += energy;
            this.steamTank.modify(-100);
        }
        while (this.fuel <= 0 && !this.steamTank.isEmpty()) {
            ++this.fuelPerCycle;
            this.fuel += energy;
            this.steamTank.modify(-100);
        }
        this.fuelMax = energy * this.fuelPerCycle;
    }

    protected void resetAttributes() {
        super.resetAttributes();
        this.fuelPerCycle = 1;
    }

    protected boolean cacheRenderFluid() {
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.steamTank.getFluidStack(), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new SteamDynamoMenu(i, Objects.requireNonNull(this.f_58857_, "Tried to construct a Steam Dynamo menu too ealy!"), this.f_58858_, inventory, player);
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }
}

