/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.roomopolis.item.custom;

import com.benbenlaw.roomopolis.block.ModBlocks;
import com.benbenlaw.roomopolis.util.ModTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyBlockRemover
extends Item {
    public KeyBlockRemover(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos blockPos = context.m_8083_();
        Direction direction = context.m_43719_();
        ItemStack stack = context.m_43722_();
        boolean blocksMatch = false;
        if (!level.m_5776_()) {
            BlockPos leftPos = null;
            BlockPos rightPos = null;
            BlockPos upPos = null;
            BlockPos downPos = null;
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    leftPos = blockPos.m_122024_();
                    rightPos = blockPos.m_122029_();
                    upPos = blockPos.m_7494_();
                    downPos = blockPos.m_7495_();
                    break;
                }
                case WEST: 
                case EAST: {
                    leftPos = blockPos.m_122012_();
                    rightPos = blockPos.m_122019_();
                    upPos = blockPos.m_7494_();
                    downPos = blockPos.m_7495_();
                    break;
                }
                case UP: 
                case DOWN: {
                    leftPos = blockPos.m_122012_();
                    rightPos = blockPos.m_122019_();
                    upPos = blockPos.m_122029_();
                    downPos = blockPos.m_122024_();
                }
            }
            BlockState leftBlock = level.m_8055_(leftPos);
            BlockState rightBlock = level.m_8055_(rightPos);
            BlockState upBlock = level.m_8055_(upPos);
            BlockState downBlock = level.m_8055_(downPos);
            if (leftBlock == rightBlock && upBlock == downBlock && leftBlock == upBlock && leftBlock != Blocks.f_50016_.m_49966_()) {
                blocksMatch = true;
            }
            assert (player != null);
            if (level.m_8055_(blockPos).m_60713_((Block)ModBlocks.BASIC_ROOM_KEY_BLOCK.get())) {
                if (blocksMatch) {
                    BlockState keyBlock = leftBlock;
                    if (keyBlock.m_204336_(ModTags.Blocks.KEY_BLOCK_SMART_BLOCKS)) {
                        level.m_46597_(blockPos, keyBlock);
                        player.m_213846_((Component)Component.m_237113_((String)("Removing Key Block and replacing smartly with " + keyBlock.m_60734_().m_49954_().getString())).m_130940_(ChatFormatting.GREEN));
                        this.shrinkItem(player, stack);
                    }
                } else {
                    level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                    player.m_213846_((Component)Component.m_237113_((String)"Removing Key Block").m_130940_(ChatFormatting.GREEN));
                    this.shrinkItem(player, stack);
                }
            }
        }
        return super.m_6225_(context);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237113_((String)"Can be used to remove a key block! Will replace with the most common block found within its range or with air.").m_130940_(ChatFormatting.GREEN));
        } else {
            components.add((Component)Component.m_237113_((String)"Hold SHIFT for more information").m_130940_(ChatFormatting.BLUE));
        }
    }

    private void shrinkItem(Player player, ItemStack stack) {
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
    }
}

