/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.roomopolis.block;

import com.benbenlaw.roomopolis.block.custom.RoomBlock;
import com.benbenlaw.roomopolis.item.ModItems;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"roomopolis");
    public static final RegistryObject<Block> BASIC_ROOM_BLOCK = ModBlocks.registerBlock("basic_room_block", () -> new RoomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> BASIC_ROOM_KEY_BLOCK = ModBlocks.registerBlock("basic_room_key_block", () -> new RoomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> ADVANCED_ROOM_KEY_BLOCK = ModBlocks.registerBlock("advanced_room_key_block", () -> new RoomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> ELITE_ROOM_KEY_BLOCK = ModBlocks.registerBlock("elite_room_key_block", () -> new RoomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_).m_60918_(SoundType.f_56743_)));

    private static ToIntFunction<BlockState> litBlockEmission(int p_50760_) {
        return p_50763_ -> (Boolean)p_50763_.m_61143_((Property)BlockStateProperties.f_61443_) != false ? p_50760_ : 0;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, CreativeModeTab tab) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn, tab);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block, CreativeModeTab tab) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

