/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.proxy;

import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.RenderTomb;
import com.lothrazar.simpletomb.event.ClientEvents;
import com.lothrazar.simpletomb.particle.ParticleCasting;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientUtils {
    public static void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
    }

    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)TombRegistry.TOMBSTONE_BLOCK_ENTITY.get(), RenderTomb::new);
    }

    public static void produceGraveSmoke(Level level, double x, double y, double z) {
        Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)TombRegistry.GRAVE_SMOKE.get(), x + level.f_46441_.m_188583_(), y, z + level.f_46441_.m_188583_(), 0.0, 0.0, 0.0);
    }

    public static void produceGraveSoul(Level level, BlockPos pos) {
        level.m_7106_((ParticleOptions)TombRegistry.SOUL.get(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 0.0, 0.0);
    }

    public static void produceParticleCasting(LivingEntity caster, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.m_91087_();
        if (caster != null && caster.m_9236_() instanceof ClientLevel) {
            for (int i = 1; i <= 2; ++i) {
                ClientLevel cworld = (ClientLevel)caster.m_9236_();
                ParticleCasting particle = new ParticleCasting(cworld, caster, predic, 0.0, (double)i * 0.5);
                mc.f_91061_.m_107344_((Particle)particle);
                particle = new ParticleCasting(cworld, caster, predic, 0.5, (double)(i + 1) * 0.5);
                mc.f_91061_.m_107344_((Particle)particle);
                particle = new ParticleCasting(cworld, caster, predic, 1.0, (double)i * 0.5);
                mc.f_91061_.m_107344_((Particle)particle);
                particle = new ParticleCasting(cworld, caster, predic, 1.5, (double)(i + 1) * 0.5);
                mc.f_91061_.m_107344_((Particle)particle);
                particle = new ParticleCasting(cworld, caster, predic, 2.0, (double)i * 0.5);
                mc.f_91061_.m_107344_((Particle)particle);
            }
        }
    }
}

